<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;



class PermissionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        \DB::table('permissions')->insert([
            ["name" => "create_user"], 				// Create new user
            ["name" => "manage_all_users"], 		// Access all users to manage
            ["name" => "manage_all_departments"], 	// Access all departments to manage
            ["name" => "manage_all_folders"], 	    // Access all folders to manage
            ["name" => "view_all_departments"], 	// Access all departments to view
            ["name" => "view_all_folders"], 	    // Access all folders to view
            ["name" => "edit_all_folders"], 		// Edit all folders
            ["name" => "edit_folder"], 		        // Edit your folder/s
            ["name" => "delete_all_folders"], 	    // Delete all folder/s
            ["name" => "delete_folder"], 	        // Delete your folder/s
            ["name" => "manage_all_files"], 	    // Access all files
            ["name" => "manage_file_types"], 	    // Access file types
        ]);
    }
}
