<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>@yield('title')</title>

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ url('assets/media/images/favicon.png') }}"/>

    <!-- Plugin styles -->
    <link rel="stylesheet" href="{{ url('vendors/bundle.css') }}" type="text/css">

@yield('head')

<!-- App styles -->
    <link rel="stylesheet" href="{{ url('assets/css/app.min.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ url('vendors/lightbox/magnific-popup.css') }}" type="text/css">

</head>
<body @if (trim($__env->yieldContent('bodyClass'))) class="@yield('bodyClass')" @endif>

<!-- begin::preloader-->
<div class="preloader">
    <div class="preloader-icon"></div>
</div>
<!-- end::preloader -->

<!-- BEGIN: Sidebar Group -->
<div class="sidebar-group">

    <!-- BEGIN: User Menu -->
    <div class="sidebar" id="user-menu">
        <div class="py-4 text-center bg-dark">
            <h5 class="d-flex align-items-center justify-content-center">{{auth()->user()->getFullName()}}</h5>
            <h6 class="d-flex align-items-center justify-content-center">{{auth()->user()->role->name}}</h6>
        </div>
        <div class="card mb-0 card-body shadow-none">
            <div class="mb-4">
                <div class="list-group list-group-flush">
                    <a href="{{route("dashboard.settings.index")}}" class="list-group-item p-l-r-0">Settings</a>
                    <a href="javascript:void(0)" onclick="
								event.preventDefault();
								document.getElementById('logout-form').submit();
							" class="list-group-item p-l-r-0 text-danger">Sign Out</a>
                    <form id="logout-form" action="{{ route("auth.logout") }}" method="post">
                        @csrf
                    </form>
                </div>
            </div>
            <div class="mb-4">
                <h6 class="d-flex justify-content-between">
                    Added documents
                    <span class="float-right">68</span>
                </h6>
                <div class="progress" style="height:5px;">
                    <div class="progress-bar bg-secondary" role="progressbar" style="width: 68%;"
                         aria-valuenow="68"
                         aria-valuemin="0" aria-valuemax="100"></div>
                </div>
            </div>
            <div class="mb-4">
                <h6 class="d-flex justify-content-between">
                    Used space
                    <span>%25</span>
                </h6>
                <div class="progress" style="height: 5px;">
                    <div class="progress-bar bg-info" role="progressbar" style="width: 40%;" aria-valuenow="40"
                         aria-valuemin="0" aria-valuemax="100"></div>
                </div>
            </div>
            <div class="mb-4">
                <h6>Email</h6>
                <p class="text-muted mb-0">{{ auth()->user()->email }}</p>
            </div>
            <div class="mb-4">
                <h6>Phone</h6>
                <p class="text-muted mb-0">{{ auth()->user()->phone_number }}</p>
            </div>
        </div>
    </div>
    <!-- END: User Menu -->

</div>
<!-- END: Sidebar Group -->

<!-- begin::main -->
<div class="layout-wrapper">

    <!-- begin::header -->
    <div class="header d-print-none">

        <div class="header-left">
            <div class="navigation-toggler">
                <a href="#" data-action="navigation-toggler">
                    <i data-feather="menu"></i>
                </a>
            </div>
            <div class="header-logo">
                <a href="{{ url('dashboard') }}">
                    <img class="logo" src="{{ url('assets/media/images/logo-small.png') }}" alt="logo">
                </a>
            </div>
        </div>

        <div class="header-body">
            <div class="header-body-left">
                <div class="page-title">
                    <h4>@yield('pageTitle')</h4>
                </div>
            </div>
            <div class="header-body-right">
                <ul class="navbar-nav">

                    <!-- begin::header fullscreen -->
                    <li class="nav-item dropdown">
                        <a href="#" class="nav-link" title="Fullscreen" data-toggle="fullscreen">
                            <i class="maximize" data-feather="maximize"></i>
                            <i class="minimize" data-feather="minimize"></i>
                        </a>
                    </li>
                    <!-- end::header fullscreen -->

                    <!-- begin::header notification dropdown -->
                    <li class="nav-item dropdown">
                    <div class="dropdown dropdown-notifications-wrapper dropdown-menu-right dropdown-menu-big">
                        <a href="javascript:void(0)" class="nav-link dropdown-notifications-unread icon" data-toggle="dropdown">
                            <i data-feather="bell"></i>
                            <span class="nav-unread"></span>
                        </a>
                        <div class="dropdown-menu dropdown-notifications dropdown-menu-right dropdown-menu-big">
                            <div class="bg-dark p-4 text-center d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">Notifications</h5>
                            </div>
                            <div class="p-4 text-center align-items-center">
                            <p class='text-center unreadNotificationsInfo'>No unread notifications</p>
                            </div>
                            <div class="dropdown-divider"></div>
                            <a href="{{ route("dashboard.notifications.index") }}" class="dropdown-item text-center text-muted-dark">See all</a>
                        </div>
                    </div>
                    </li>

{{--                    </li>--}}
                    <!-- end::header notification dropdown -->

                    <!-- begin::user menu -->
                    <li class="nav-item dropdown">
                        <a href="#" class="nav-link" title="User menu" data-sidebar-target="#user-menu">
                            <span class="mr-2 d-sm-inline d-none">{{auth()->user()->getFullName()}}</span>
                            @include('dashboard.partials.avatar')
                        </a>
                    </li>
                    <!-- end::user menu -->

                </ul>

                <!-- begin::mobile header toggler -->
                <ul class="navbar-nav d-flex align-items-center">
                    <li class="nav-item header-toggler">
                        <a href="#" class="nav-link">
                            <i data-feather="arrow-down"></i>
                        </a>
                    </li>
                </ul>
                <!-- end::mobile header toggler -->
            </div>
        </div>

    </div>
    <!-- end::header -->

    <div class="content-wrapper">

        <!-- begin::navigation -->
        <div class="navigation">
            <div class="navigation-menu-tab">
                <ul>
                    <li>
                        <a href="{{ route("dashboard.index") }}" class="nav-link {{ request()->is('dashboard') ? 'active' : '' }}" data-toggle="tooltip"
                           data-placement="right" title="Dashboard">
                            <i data-feather="home"></i>
                        </a>
                    </li>
                    @if(auth()->user()->hasPermission("manage_all_users"))
                        <li>
                            <a href="{{ route("dashboard.users.index") }}" class="nav-link {{ request()->is(['dashboard/users', 'dashboard/users/*']) ? 'active' : '' }}" data-toggle="tooltip"
                               data-placement="right" title="Users">
                                <i data-feather="users"></i>
                            </a>
                        </li>
                    @endif
                    @if(auth()->user()->hasPermission("manage_all_departments"))
                        <li>
                            <a href="{{route("dashboard.departments.index")}}" data-toggle="tooltip"
                               data-placement="right" title="Departments">
                                <i data-feather="grid"></i>
                            </a>
                        </li>
                    @endif
                    @if(auth()->user()->hasPermission("manage_all_folders"))
                        <li>
                            <a href="{{route("dashboard.folders.index")}}" data-toggle="tooltip"
                               data-placement="right" title="Folders">
                                <i data-feather="folder"></i>
                            </a>
                        </li>
                    @endif
                    @if(auth()->user()->hasPermission("manage_all_files"))
                        <li>
                            <a href="{{route("dashboard.files.index")}}" data-toggle="tooltip"
                               data-placement="right" title="Files">
                                <i data-feather="file-text"></i>
                            </a>
                        </li>
                    @endif
                </ul>
            </div>
        </div>
        <!-- end::navigation -->

        <div class="content-body">

            <div class="content">

                @yield('content')

            </div>

            <!-- begin::footer -->
            <footer class="content-footer">
                <div>© {{ date('Y') }}<a href="{{route("dashboard.index")}}" target="_blank"> SaveSpace</a></div>
                <div>
                </div>
            </footer>
            <!-- end::footer -->
        </div>

    </div>

</div>
<!-- end::main -->

<!-- Plugin scripts -->
<script src="{{ url('vendors/bundle.js') }}"></script>

<!-- App scripts -->
<script src="{{ url('assets/js/app.js') }}"></script>
<!-- 3. Instantiate clipboard by passing a string selector -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.8/clipboard.min.js"></script>
<script>
    var clipboard = new ClipboardJS('.btn');
</script>
<script src="{{ url('vendors/lightbox/jquery.magnific-popup.min.js') }}"></script>

<!-- Isotope -->
<script src="{{ url('vendors/jquery.isotope.min.js') }}"></script>

<script src="{{ url('assets/js/examples/pages/gallery.js') }}"></script>
@yield('script')


@include("layouts.alert")

</body>
</html>
