<?php

namespace App\Http\Controllers\Dashboard;

use App\Helpers\Alert;
use App\Http\Requests\Dashboard\NewDepartmentRequest;
use App\Http\Requests\Dashboard\UpdateDepartmentRequest;
use App\Models\Department;
use App\Models\Document;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class DepartmentsController extends Controller
{
    public function index()
    {
        return view("dashboard.departments.index")->with([
            "departments" => Department::all(),
        ]);
    }

    public function create()
    {
        return view("dashboard.departments.create");
    }

    public function store(NewDepartmentRequest $request)
    {
        $department = new Department();

        $department->name = $request->name;
        $department->code = $request->code;

        if(!Storage::disk('local')->has('Departments/' . $request->code)){
            Storage::disk('local')->makeDirectory('Departments/' . $request->code);
        }

        $department->user_id = auth()->id();
        $department->location = '/Departments/' . $request->code;

        $department->save();

        Alert::flash("New Department added successfully");

        return redirect()->route("dashboard.departments.index");
    }

    public function editShow($id)
    {
        return view("dashboard.departments.edit")->with([
            "department" => Department::findOrFail($id)
        ]);
    }

    public function edit(UpdateDepartmentRequest $request, $id)
    {
        $department = Department::findOrFail($id);

        $oldDepartmentCode = $department->code;

        $department->name = $request->name;
        $department->code = $request->code;
        $department->updated_at = Carbon::now();;

        $path = '/Departments/' . $request->code;
        $department->location = $path;

        $files = Storage::allFiles($oldDepartmentCode);

        if($department->isDirty('code'))
        {
            if(!Storage::disk('local')->has('Departments/' . $request->code)){
                Storage::disk('local')->move('Departments/' . $oldDepartmentCode, 'Departments/' . $department->code);
            }
        }

        $department->save();

        Alert::flash("Department edited successfully");

        return redirect()->route("dashboard.departments.index");
    }

    public function destroy($id)
    {
        $department = Department::find($id);
        //$department->delete();
        $documents = $department->document()->count();

        if($documents > 0){
            Alert::flash($department->name . " has " . $documents . " document/s associated", "error");
        }
        else {
            $department->delete();

            Alert::flash($department->name . " deleted successfully");
        }

        return redirect()->route("dashboard.departments.index");
    }
}
