<?php

namespace App\Models;

use App\Rules\ValidationRuleSyntaxChecker;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FileType extends Model
{
    use HasFactory;

    protected $table = "file_types";

    protected $fillable = [
        'name',
        'file_validations',
        'file_maxsize',
        "user_id"
    ];

    public function getCreatedByName()
    {
        return User::where('id', $this->user_id)->pluck('username')->first();
    }
}
