<?php

namespace Database\Factories;

use App\Models\Department;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Storage;

class DepartmentFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Department::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $location = $this->faker->unique()->numberBetween(1, 99);
        Storage::disk('local')->makeDirectory('Departments/' . $location);
        return [
            'id' => $this->faker->unique()->randomNumber(),
            'name' => $this->faker->name(),
            'code' => $location,
            'location' => 'Departments/' . $location,
            'user_id' => $this->faker->numberBetween('1', '2'),
            'created_at' => Carbon::now()
        ];
    }
}
