@extends('layouts.app')

@section("title", "SaveSpace - Documents")

@section('pageTitle', 'SaveSpace - Documents')

@section('content')

    <div class="row app-block mb-4">
        <div class="col-md-3 app-sidebar">
            <div class="card">
                <div class="card-body">
                    <a href="{{ route("dashboard.documents.create") }}" class="btn btn-secondary btn-block file-upload-btn text-white" data-action="{{ route("dashboard.documents.create") }}">
                        Add document
                    </a>
                    <form class="d-none" id="file-upload">
                        <input type="file" multiple>
                    </form>
                </div>
                <div class="app-sidebar-menu">
                    <div class="list-group list-group-flush">
                        <a href="{{route("dashboard.documents.index")}}" class="list-group-item d-flex align-items-center">
                            <i data-feather="folder" class="width-15 height-15 mr-2"></i>
                            Documents
{{--                            <span class="small ml-auto">{{$totalDocs}}</span>--}}
                        </a>
                        @foreach($departments as $department)
                            <a href="{{ route("dashboard.documents.index", ["id" => $department->id]) }}" class="list-group-item d-flex align-items-center">
                                <i data-feather="folder" class="width-15 height-15 mr-2"></i>
                                {{$department->name}}
                                <span class="small ml-auto">{{$department->document->count()}}</span>
                            </a>
                        @endforeach
                        <a href="" class="list-group-item">
                            <i data-feather="upload-cloud" class="width-15 height-15 mr-2"></i>
                            Recents
                        </a>
                        <a href="" class="list-group-item d-flex align-items-center">
                            <i data-feather="star" class="width-15 height-15 mr-2"></i>
                            Important
                            <span class="small ml-auto">10</span>
                        </a>
                        <a href="" class="list-group-item">
                            <i data-feather="trash" class="width-15 height-15 mr-2"></i>
                            Deleted Files
                        </a>
                    </div>
                    <div class="card-body">
                        <h6 class="mb-4">Storage Status</h6>
                        <div class="d-flex align-items-center">
                            <div class="mr-3">
                                <i data-feather="database" class="width-30 height-30"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="progress" style="height: 10px">
                                    <div class="progress-bar progress-bar-striped" role="progressbar"
                                         style="width: 40%" aria-valuenow="10" aria-valuemin="0"
                                         aria-valuemax="100"></div>
                                </div>
                                <div class="line-height-12 small text-muted mt-2">19.5GB used of 25GB</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="col-md-9 app-content">
            <div class="app-content-overlay"></div>
            <div class="app-action">
                <div class="action-left">
                    <ul class="list-inline">
                        <li class="list-inline-item mb-0">
                            <a href="#" class="btn btn-outline-light dropdown-toggle" data-toggle="dropdown">
                                <i data-feather="plus" class="mr-1"></i>
                                Add
                            </a>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="{{route("dashboard.departments.create")}}">Department</a>
                                <a class="dropdown-item" href="{{route("dashboard.documents.create")}}">Document</a>
                            </div>
                        </li>
                        <li class="list-inline-item mb-0">
                            <a href="#" class="btn btn-outline-light dropdown-toggle" data-toggle="dropdown">Departments</a>
                            <div class="dropdown-menu">
                                @foreach($departments as $department)
                                    <a class="dropdown-item d-flex justify-content-between m-5" href="{{ route("dashboard.documents.index", ["id" => $department->id]) }}">
                                        {{$department->name}}
                                        <span class="text-muted">{{$department->document->count()}}</span>
                                    </a>
                                @endforeach
                            </div>
                        </li>
                        <li class="list-inline-item mb-0">
                            <a href="#" class="btn btn-outline-light dropdown-toggle" data-toggle="dropdown">
                                Order by
                            </a>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="#">Date</a>
                                <a class="dropdown-item" href="#">Name</a>
                                <a class="dropdown-item" href="#">Size</a>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="action-right">
                    <form class="d-flex mr-3">
                        <a href="#" class="app-sidebar-menu-button btn btn-outline-light">
                            <i data-feather="menu"></i>
                        </a>
                        <div class="input-group">
                            <input type="text" class="form-control" placeholder="Search file"
                                   aria-describedby="button-addon1">
                            <div class="input-group-append">
                                <button class="btn btn-outline-light" type="button" id="button-addon1">
                                    <i data-feather="search"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>


            <p>Documents</p>
            <div class="row">
                @forelse($documents as $document)
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12">
                        <div class="card app-file-list">
                            <div class="app-file-icon">
                                <i class="fa fa-file-text-o text-primary"></i>
                                <div class="dropdown position-absolute top-0 right-0 mr-3">
                                    <a href="#" class="btn btn-outline-light btn-sm" data-toggle="dropdown">
                                        <i class="fa fa-ellipsis-h"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-right">
                                        <a href="{{ route("dashboard.documents.edit", ["id" => $document->id]) }}" class="dropdown-item">View Details</a>
                                        <a href="#" class="dropdown-item">Share</a>
                                        <a href="#" class="dropdown-item">Download</a>
                                        <a href="#" class="dropdown-item">Move to</a>
                                        <a href="#" class="dropdown-item">Delete</a>
                                    </div>
                                </div>
                            </div>
                            <div class="p-2 small">
                                <div>{{$document->name}} - {{$document->arch_id}}</div>
                                <div class="text-muted">{{$document->description}}</div>
                                <div class="text-muted">1.2MB</div>
                            </div>
                        </div>
                    </div>
                @empty
                    <div>No items found</div>
                @endforelse

            </div>
    </div>

@endsection

@section('script')



@endsection
