@extends('layouts.app')

@section("title", "Users - Edit user")

@section('pageTitle', 'Edit user')

@section('content')

    <div class="page-header">
        <nav aria-label="breadcrumb" class="d-flex align-items-start">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('dashboard/users') }}">Users</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Edit user</li>
            </ol>
        </nav>
    </div>

    <div class="row">
        <div class="col-md-12">

            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <div class="tab-content" id="v-pills-tabContent">
                        <div class="tab-pane fade show active" id="v-pills-home" role="tabpanel" aria-labelledby="v-pills-home-tab">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="card-title">User account data</h6>
                                    <form action="{{ route("dashboard.users.edit", ["id" =>$user->id]) }}" method="post" accept-charset="utf-8" enctype='multipart/form-data' class="needs-validation" novalidate>
                                        @method("patch")
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Name</label>
                                                    <input type="text" name="name" value="{{ $user->name }}" minlength="2" maxlength="30" pattern="[a-zA-Zа-шА-Ш._\s]+" class="form-control" placeholder="Name" required>
                                                    <div class="invalid-feedback">
                                                        Please enter only letters and spaces with length between [2, 30]
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Surname</label>
                                                    <input type="text" name="surname" value="{{$user->surname}}" minlength="2" maxlength="30" pattern="[a-zA-Zа-шА-Ш._\s]+" class="form-control" placeholder="Surname" required>
                                                    <div class="invalid-feedback">
                                                        Please enter only letters and spaces with length between [2, 30]
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label">Username</label>
                                                    <input type="text" name="username" value="{{ $user->username }}" minlength="5" maxlength="30" class="form-control" placeholder="Username" required>
                                                    <div class="invalid-feedback">
                                                        Please enter characters with length between [5, 30]
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label">Role</label>

                                                    <select class="form-control" name="userRole" required>
                                                        @foreach($roles as $role)
                                                            <option value="{{ $role->id }}" {{ $user->role_id == $role->id ? "selected" : "" }}>{{ $role->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Email</label>
                                                    <input type="email" name="email" value="{{ $user->email }}" maxlength="50" class="form-control" placeholder="E-mail" required>
                                                    <div class="invalid-feedback">
                                                        Please enter a valid email address with length <=50
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label">Phone Number</label>
                                                    <input type="text" name="phone_number" value="{{ $user->phone_number }}" class="form-control" placeholder="Phone number" autocomplete="off" required>
                                                    <div class="invalid-feedback">
                                                        Please enter your phone number
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-5">
                                                <div class="form-group">
                                                    <label>Avatar</label>
                                                    <input type="file" name="avatar" value="{{ $user->avatar }}" class="form-control" accept="image/*">
                                                    <div class="invalid-feedback">
                                                        Please upload a valid image file
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-1">
                                                <div class="form-group">
                                                    <label>Current</label>
                                                    @include('dashboard.partials.avatar')
                                                </div>
                                            </div>
                                        </div>
                                        <input type="submit" value="Save changes" class="submitBtn btn btn-primary pull-right m-10">
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
