<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFoldersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('folders', function (Blueprint $table) {
            $table->bigIncrements('id')->startingValue(1);
            $table->string("arch_id");
            $table->string("name");
            $table->text("note")->nullable();
            $table->string("location");
            $table->integer("no_of_files")->default(0);
            $table->integer("user_id")->unsigned();
            $table->integer("department_id")->unsigned();
            $table->integer("version")->default(1);
            $table->timestamps();

            $table->foreign("user_id")->references("id")->on("users")->onDelete("cascade")->onUpdate("cascade");
            $table->foreign("department_id")->references("id")->on("departments")->onDelete("cascade")->onUpdate("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('folders');
    }
}
