@extends('layouts.app')

@section("title", "SaveSpace - Folder")

@section('content')

    <div class="row app-block mb-4">
        <div class="col-md-3 app-sidebar">
            <div class="card">
                <div class="app-sidebar-menu">
                    <div class="list-group list-group-flush">
                        <a href="{{route("dashboard.folders.index")}}" class="list-group-item d-flex align-items-center">
                            <i data-feather="folder" class="width-15 height-15 mr-2"></i>
                            Folders
                        </a>
                        @foreach($folders as $obj)
                            <a href="{{ route("dashboard.folders.files", ["id" => $obj->id]) }}" class="list-group-item d-flex align-items-center">
                                <i data-feather="folder" class="width-15 height-15 mr-2"></i>
                                {{$obj->name}}
                                <span class="small ml-auto">{{$obj->files->count()}}</span>
                            </a>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-9 app-content">
            <div class="app-content-overlay"></div>
            <div class="app-action">
                <div class="action-left">
                    <ul class="list-inline">
                        <li class="list-inline-item mb-0">
                            @if(auth()->user()->hasPermission('download_data'))
                            <a href="{{ route("dashboard.folders.downloadFolder", ['id' => $folder->id]) }}" class="btn btn-outline-light">
                                Download folder
                            </a>
                                @endif
                        </li>
                    </ul>
                </div>
                <div class="action-right">
                    <form action="{{ route("dashboard.folders.files", $folder->id) }}" method="get" class="d-flex mr-3">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="Search files"
                                   aria-describedby="button-addon1" required>
                            <div class="input-group-append">
                                <button class="btn btn-outline-light searchSubmitBtn" type="submit" value="Search">
                                    <i data-feather="search"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <p>Files</p>

            <div class="row">
                @forelse($files as $file)
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12">
                        <div class="card app-file-list">
                            <div class="app-file-icon">
                                @if(in_array(explode('.', $file->name)[1], $excelExt))
                                    <i class="fa fa-file-excel-o text-success"></i>
                                @else @if(in_array(explode('.', $file->name)[1], $textExt))
                                    <i class="fa fa-file-word-o text-info"></i>
                                @else @if(explode('.', $file->name)[1] == 'pdf')
                                        <i class="fa fa-file-pdf-o text-danger"></i>
                                    @else @if(in_array(explode('.', $file->name)[1], $imageExt))
{{--                                            <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">--}}
{{--                                                <a href="{{ url('/storage/' . $file->location) }}" class="image-popup-gallery-item">--}}
{{--                                                    <div class="image-hover">--}}
{{--                                                        <img src="{{ url('/storage/' . $file->location) }}" class="rounded" width="100" alt="image">--}}
{{--                                                    </div>--}}
{{--                                                </a>--}}
{{--                                            </div>--}}
                                            <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">
                                                <i class="fa fa-file-image-o text-danger fa-2x"></i>
                                            </div>
                                        @else
                                            <i class="fa fa-file-text-o text-warning"></i>
                                        @endif
                                    @endif
                                @endif
                                @endif
                                <div class="dropdown position-absolute top-0 right-0 mr-3">
                                    <a href="#" class="btn btn-outline-light btn-sm" data-toggle="dropdown">
                                        <i class="fa fa-ellipsis-h"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-right">
                                        @if(auth()->user()->hasPermission('download_data'))
                                        <a href="{{ route("dashboard.files.downloadFile", $file->id) }}" class="dropdown-item">
                                            Download
                                        </a>
                                            @endif
                                            @if(auth()->user()->hasPermission('manage_all_files'))
                                        <a href="javascript:void(0)" class="dropdown-item" data-toggle="modal" data-target="#deleteModal_{{$file->id}}">
                                            Delete
                                        </a>
                                                @endif
                                    </div>
                                </div>
                            </div>
                            <div class="p-2 small">
                                <div>{{$file->name}}</div>
                                <div class="text-muted">{{ $file->getSize($file->location) }} MB</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade" id="deleteModal_{{$file->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalCenterTitle">Delete confirmation</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <i class="ti-close"></i>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{ route("dashboard.files.deleteFile", $file->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <p>Are you sure you want to delete file {{$file->name}}?</p>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                            </button>
                                            <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

                @empty
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12">No items found</div>
                @endforelse

            </div>

            @if(!Request::query('search'))
                {{$files->appends($_GET)->links('layouts.pagination') }}
            @endif

        </div>

    </div>

@endsection

@yield('script')


