<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Document extends Model
{
    use HasFactory;
    protected $table = "documents";

    protected $fillable = ["arch_id", "name", "description", "user_id", "department_id", "is_important"];


    public function user() {
        return $this->belongsTo(User::class);
    }

    public function department() {
        return $this->belongsTo(Department::class);
    }

    public function files()
    {
        return $this->hasMany(File::class);
    }
}
