<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class File extends Model
{
    protected $table = "files";
    protected $fillable = ["name", "location", "document_id"];

    public function document()
    {
        return $this->belongsTo(Document::class);
    }

    public function getSize($location)
    {
        $fileSize = Storage::disk('local')->size($location) / 1024 / 1024;
        $fileSize = round($fileSize, 2);
        return $fileSize;
    }
}
