<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RolesPermissions extends Model
{
    protected $table = "roles_permissions";

    protected $fillable = ["role_id", "permission_id"];

    public function permission() {
        return $this->hasMany(Permission::class, "permissions");
    }

    public function role() {
        return $this->hasMany(Role::class, "roles");
    }
}
