@extends('layouts.app')

@section("title", "SaveSpace - Folder")

@section('content')

    <div class="row app-block mb-4">
        <div class="col-md-3 app-sidebar">
            <div class="card">
                <div class="card-body">
                    @if(auth()->user()->hasPermission('manage_all_folders'))
                    <a class="btn btn-secondary btn-block text-white" href="javascript:void(0)" data-target="#createModal{{$folder->id}}" data-toggle="modal">
                        Edit folder
                    </a>
                        @endif
                </div>
                <div class="app-sidebar-menu">
                    <div class="list-group list-group-flush">
                        <a href="{{route("dashboard.folders.index")}}" class="list-group-item d-flex align-items-center">
                            <i data-feather="folder" class="width-15 height-15 mr-2"></i>
                            Folders
                        </a>
                        @foreach($folders as $obj)
                            <a href="{{ route("dashboard.folders.files", ["id" => $obj->id]) }}" class="list-group-item d-flex align-items-center">
                                <i data-feather="folder" class="width-15 height-15 mr-2"></i>
                                {{$obj->name}}
                                <span class="small ml-auto">{{$obj->files->count()}}</span>
                            </a>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-9 app-content">
            <div class="app-content-overlay"></div>
            <div class="app-action">
                <div class="action-left">
                    <ul class="list-inline">
                        @if(auth()->user()->hasPermission('manage_all_folders'))
                        <li class="list-inline-item mb-0">
                            <a href="#" class="btn btn-outline-light dropdown-toggle" data-toggle="dropdown">
                                Actions
                            </a>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="javascript:void(0)" data-toggle="modal" data-target="#editModal_{{$folder->id}}">
                                    Edit folder
                                </a>
                            </div>
                        </li>
                        @endif
                        <li class="list-inline-item mb-0">
                            @if(auth()->user()->hasPermission('download_data'))
                            <a href="{{ route("dashboard.folders.downloadFolder", ['id' => $folder->id]) }}" class="btn btn-outline-light">
                                Download folder
                            </a>
                                @endif
                        </li>
                    </ul>
                </div>
                <div class="action-right">
                    <form action="{{ route("dashboard.folders.files", $folder->id) }}" method="get" class="d-flex mr-3">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="Search files"
                                   aria-describedby="button-addon1" required>
                            <div class="input-group-append">
                                <button class="btn btn-outline-light searchSubmitBtn" type="submit" value="Search">
                                    <i data-feather="search"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <p>Files</p>

            <div class="row">
                @forelse($files as $file)
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12">
                        <div class="card app-file-list">
                            <div class="app-file-icon">
                                @if(in_array(explode('.', $file->name)[1], $excelExt))
                                    <i class="fa fa-file-excel-o text-success"></i>
                                @else @if(in_array(explode('.', $file->name)[1], $textExt))
                                    <i class="fa fa-file-word-o text-info"></i>
                                @else @if(explode('.', $file->name)[1] == 'pdf')
                                        <i class="fa fa-file-pdf-o text-danger"></i>
                                    @else @if(in_array(explode('.', $file->name)[1], $imageExt))
{{--                                            <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">--}}
{{--                                                <a href="{{ url('/storage/' . $file->location) }}" class="image-popup-gallery-item">--}}
{{--                                                    <div class="image-hover">--}}
{{--                                                        <img src="{{ url('/storage/' . $file->location) }}" class="rounded" width="100" alt="image">--}}
{{--                                                    </div>--}}
{{--                                                </a>--}}
{{--                                            </div>--}}
                                            <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">
                                                <i class="fa fa-file-image-o text-danger fa-2x"></i>
                                            </div>
                                        @else
                                            <i class="fa fa-file-text-o text-warning"></i>
                                        @endif
                                    @endif
                                @endif
                                @endif
                                <div class="dropdown position-absolute top-0 right-0 mr-3">
                                    <a href="#" class="btn btn-outline-light btn-sm" data-toggle="dropdown">
                                        <i class="fa fa-ellipsis-h"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-right">
                                        @if(auth()->user()->hasPermission('manage_all_files'))
                                        <a href="javascript:void(0)" class="dropdown-item" data-toggle="modal" data-target="#editFileModal_{{$file->id}}">
                                            Rename
                                        </a>
                                        @endif
                                        @if(auth()->user()->hasPermission('download_data'))
                                        <a href="{{ route("dashboard.files.downloadFile", $file->id) }}" class="dropdown-item">
                                            Download
                                        </a>
                                            @endif
                                            @if(auth()->user()->hasPermission('manage_all_files'))
                                        <a href="javascript:void(0)" class="dropdown-item" data-toggle="modal" data-target="#deleteModal_{{$file->id}}">
                                            Delete
                                        </a>
                                                @endif
                                    </div>
                                </div>
                            </div>
                            <div class="p-2 small">
                                <div>{{$file->name}}</div>
                                <div class="text-muted">{{ $file->getSize($file->location) }} MB</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade" id="deleteModal_{{$file->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalCenterTitle">Delete confirmation</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <i class="ti-close"></i>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{ route("dashboard.files.deleteFile", $file->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <p>Are you sure you want to delete file {{$file->name}}?</p>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                            </button>
                                            <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="modal fade" id="editFileModal_{{$file->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalCenterTitle">Edit file name</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <i class="ti-close"></i>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{ route("dashboard.files.renameFile", ["id" =>$file->id]) }}" method="post" accept-charset="utf-8">
                                        @method("patch")
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="form-label">Current name: {{$file->name}}</label>
                                                    <input type="text" name="name" value="{{ explode('.', $file->name)[0] }}" maxlength="255" title="Don't include: '\/.|'" pattern="^[^.\/|]+$" class="form-control" required>
                                                </div>
                                            </div>
                                        </div>
                                        <br/>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                            </button>
                                            <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12">No items found</div>
                @endforelse

                    <div class="modal fade" id="editModal_{{$folder->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalCenterTitle">Edit folder</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <i class="ti-close"></i>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{ route("dashboard.folders.edit", ["id" => $folder->id]) }}" method="post" accept-charset="utf-8" enctype="multipart/form-data">
                                        @method("patch")
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Department</label>
                                                    <select class="form-control edit_folder_deparment" name="department" required>
                                                        @foreach ($departments as $department)
                                                            <option value="{{ $department->id }}" data-dept-code="{{ $department->code }}" {{ old("department", $folder->department->id) == $department->id ? "selected" : "" }}>{{ $department->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Archive ID</label>
                                                    <input type="text" name="arch_id" value="{{ old("arch_id", $folder->arch_id) }}" class="form-control" placeholder="Archive ID" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Name</label>
                                                    <input type="text" name="name" value="{{ old("name", $folder->name) }}" class="form-control" placeholder="Name" minlength="2" maxlength="30" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Note</label>
                                                    <textarea class="form-control" name="note" maxlength="80">
                                                        {{ old("note", $folder->note) }}
                                                    </textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <input type="file" class="form-control" id="file-item" name="file_item[]" accept="{{ $fileTypes }}" multiple>
                                            </div>
                                        </div>
                                        <br/>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                            </button>
                                            <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalCenterTitle">Create folder</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <i class="ti-close"></i>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{ route("dashboard.folders.store") }}" method="post" accept-charset="utf-8" enctype="multipart/form-data">
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="exampleFormControlSelect1">Department</label>
                                                    @if($departments->count())
                                                        <select class="form-control new_folder_deparment" name="department" required>
                                                            @foreach ($departments as $department)
                                                                <option value="{{ $department->id }}" data-dept-code="{{ $department->code }}" {{ (old("department") == $department->id ? "selected" : "") }}>{{ $department->name }}</option>
                                                            @endforeach
                                                            @else
                                                                <p>You haven't created any departments yet. <a class="text-primary" href="{{ route("dashboard.departments.create") }}">Create now.</a></p>
                                                            @endif
                                                        </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Archive ID</label>
                                                    <input type="text" name="arch_id" value="" class="form-control" placeholder="Archive ID" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Name</label>
                                                    <input type="text" name="name" value="{{ old("name") }}" minlength="2" maxlength="30" class="form-control" placeholder="Name" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Note</label>
                                                    <textarea class="form-control" name="note" maxlength="80"> {{old("note")}} </textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <input type="file" class="form-control" id="file-item" name="file_item[]" accept="{{ $fileTypes }}" multiple>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" value="{{old("is_important")}}" id="is_important" name="is_important">
                                                        <label class="form-check-label">
                                                            Mark as important
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <br/>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                            </button>
                                            <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
            </div>

            @if(!Request::query('search'))
                {{$files->appends($_GET)->links('layouts.pagination') }}
            @endif

        </div>

    </div>

@endsection

@yield('script')


