package edu.gjoko.schedlr.services;

import edu.gjoko.schedlr.entity.Business;
import edu.gjoko.schedlr.entity.Stakeholder;
import edu.gjoko.schedlr.entity.StakeholderType;
import edu.gjoko.schedlr.repositories.BusinessRepository;
import lombok.AllArgsConstructor;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

import java.util.List;

import static edu.gjoko.schedlr.entity.BusinessStatus.ACTIVE;
import static edu.gjoko.schedlr.entity.BusinessStatus.NEW;

@Service
@AllArgsConstructor
public class BusinessService {

    private final BusinessRepository businessRepository;
    private final ServicesService servicesService;
    private final StakeholderService stakeholderService;
    private BCryptPasswordEncoder bCryptPasswordEncoder;

    public void saveBusiness(Business business) {
        servicesService.saveNewServiceTypes(business);
        business.getOwner().setStakeholderType(StakeholderType.BUSINESS_OWNER);
        business.getOwner().setPassword(bCryptPasswordEncoder.encode(business.getOwner().getPassword()));
        business.setBusinessStatus(NEW);
        businessRepository.save(business);
    }

    public List<Business> findAll() {
        return businessRepository.findAll();
    }

    public void updateBusinesses(List<Business> businessList, Long businessOwnerId) {
        businessList
                .stream()
                .forEach(business -> {
                    stakeholderService.saveOrUpdateStakeholder(business.getOwner(), businessOwnerId);
                });
    }

    public void updateBusinessStatuses(List<Business> businessList) {
        businessList
                .stream()
                .forEach(business -> {
                    Business business1 = businessRepository.findById(business.getId()).get();
                    business1.setBusinessStatus(business.getBusinessStatus());
                    businessRepository.save(business1);
                });
    }

    public Business findByOwner(Long ownerId) {
        var owner = new Stakeholder();
        owner.setId(ownerId);
        return businessRepository.findBusinessByOwner(owner);
    }

    public List<Business> findByBusinessTypeAndActiveStatus(Long businessTypeId) {
        return businessRepository.findBusinessesByBusinessStatusAndBusinessType_Id(ACTIVE, businessTypeId);
    }
}
