package edu.gjoko.schedlr.services;

import edu.gjoko.schedlr.entity.Business;
import edu.gjoko.schedlr.entity.ServiceStatus;
import edu.gjoko.schedlr.entity.ServiceType;
import edu.gjoko.schedlr.repositories.BusinessRepository;
import edu.gjoko.schedlr.repositories.BusinessTypeRepository;
import edu.gjoko.schedlr.repositories.ServiceRepository;
import edu.gjoko.schedlr.repositories.ServiceTypeRepository;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.List;
import java.util.Optional;

@Service
@AllArgsConstructor
public class ServicesService {

    private final ServiceRepository serviceRepository;
    private final ServiceTypeRepository serviceTypeRepository;
    private final BusinessRepository businessRepository;

    @Transactional
    public void deleteByIds(List<Long> ids) {
        ids.forEach(this::deactivateService);
    }

    public void saveOrUpdateServices(List<edu.gjoko.schedlr.entity.Service> serviceList, Long ownerId) {
        if (!CollectionUtils.isEmpty(serviceList)) {
            serviceList.forEach( service -> {
                Optional<edu.gjoko.schedlr.entity.Service> foundOptional;
                if (service.getId() != null && (foundOptional = serviceRepository.findById(service.getId())).isPresent()) {
                    var found = foundOptional.get();
                    found.setDuration(service.getDuration());
                    found.setPrice(service.getPrice());
                    found.setServiceStatus(ServiceStatus.ACTIVE);
                    serviceRepository.save(found);
                } else {
                    var business = businessRepository.findBusinessesByOwner_Id(ownerId);
                    service.getServiceType().setBusinessType(business.getBusinessType());
                    service.setServiceStatus(ServiceStatus.ACTIVE);
                    service.setBusiness(business);
                    serviceTypeRepository.save(service.getServiceType());
                    serviceRepository.save(service);
                }
            });
        }
    }

    public void saveNewServiceTypes(Business business) {
        business.getServices()
                .forEach(service -> {
                    if (service.getServiceType().getId() == null) {
                        ServiceType serviceType = service.getServiceType();
                        serviceType.setBusinessType(business.getBusinessType());
                        service.setServiceType(serviceTypeRepository.save(serviceType));
                    }
                });
    }

    private void deactivateService(Long id) {
        Optional<edu.gjoko.schedlr.entity.Service> serviceOptional;
        if((serviceOptional = serviceRepository.findById(id)).isPresent()) {
            var service = serviceOptional.get();
            service.setServiceStatus(ServiceStatus.INACTIVE);
            serviceRepository.save(service);
        }
    }
}
