package edu.gjoko.schedlr.services;

import edu.gjoko.schedlr.entity.Stakeholder;
import edu.gjoko.schedlr.entity.StakeholderType;
import edu.gjoko.schedlr.repositories.StakeholderRepository;
import lombok.RequiredArgsConstructor;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class StakeholderService {

    private final StakeholderRepository stakeholderRepository;
    private final BCryptPasswordEncoder bCryptPasswordEncoder;

    public void saveStakeholder(Stakeholder stakeholder) {
        stakeholder.setPassword(bCryptPasswordEncoder.encode(stakeholder.getPassword()));
        stakeholder.setStakeholderType(StakeholderType.CUSTOMER);
        stakeholderRepository.save(stakeholder);
    }

    public Stakeholder findById(Long id) {
        return stakeholderRepository.findById(id).get();
    }

    public void saveOrUpdateStakeholder(Stakeholder stakeholder, Long businessOwnerId) {
        var found = stakeholderRepository.findById(businessOwnerId).get();
        found.setFirstName(stakeholder.getFirstName());
        found.setLastName(stakeholder.getLastName());
        found.setPhoneNumber(stakeholder.getPhoneNumber());
        found.setEmail(stakeholder.getEmail());
        found.setUsername(stakeholder.getUsername());
        stakeholderRepository.save(found);
    }
}
