$(document).ready(function() {
    let companies = [];

    getCompanies().then(function (data) {
        companies = data;
    });

    $('#save_button').click(function () {
        var companiesToSave = [];
        $.each($('#table_body tr'), function(index, row) {
            if((companies[index].businessStatus === "NEW" || companies[index].businessStatus === "DEACTIVATED") &&  $($($(row).children() [3]).children()[0]).is(':checked')) {
                let cloneCompany = { ...companies[index] }
                cloneCompany['businessStatus'] = 'ACTIVE';
                companiesToSave.push(cloneCompany);
            }
            if(companies[index].businessStatus === "ACTIVE" && !$($($(row).children() [3]).children()[0]).is(':checked')) {
                let cloneCompany = { ...companies[index] }
                cloneCompany['businessStatus'] = 'DEACTIVATED';
                companiesToSave.push(cloneCompany);
            }
        });


        $.ajax({
            url: "http://localhost:8080/api/admin",
            type:"PATCH",
            data: JSON.stringify(companiesToSave),
            contentType:"application/json; charset=utf-8",
            dataType: 'text',
            success: function(succ){
                getCompanies().then(function (data) {
                    companies = data;
                });
                alert( "Updates applied successfully" );
            },
            error: function(err) {
                alert(err);
            }
        });
        event.preventDefault();
    });

    function getCompanies() {
        return $.ajax({
            url: "http://localhost:8080/api/business"
        }).then(function (data) {
            var $el = $("#table_body");
            $("#new_table tbody").html("");
            $.each(data, function (index, obj) {
                if(obj.businessStatus == "NEW" || obj.businessStatus == "DEACTIVATED") {
                    $el.append("<tr>\n" +
                        "            <th scope=\"row\">" + obj.id + "</th>\n" +
                        "            <td>" + obj.companyName + "</td>\n" +
                        "            <td>" + obj.owner.firstName + " " + obj.owner.lastName + "</td>\n" +
                        "            <td><input class=\"form-check-input\" type=\"checkbox\" value=\"" + obj.id +"\"></td>\n" +
                        "        </tr>")
                }
                if (obj.businessStatus == "ACTIVE") {
                    $el.append("<tr>\n" +
                        "            <th scope=\"row\">" + obj.id + "</th>\n" +
                        "            <td>" + obj.companyName + "</td>\n" +
                        "            <td>" + obj.owner.firstName + " " + obj.owner.lastName + "</td>\n" +
                        "            <td><input class=\"form-check-input\" type=\"checkbox\" checked value=\"" + obj.id +"\"></td>\n" +
                        "        </tr>")
                }
            });
            return data;
        });
    }
});