package edu.gjoko.schedlr.controllers.rest;

import edu.gjoko.schedlr.entity.Business;
import edu.gjoko.schedlr.services.BusinessService;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("api/admin")
@AllArgsConstructor
public class AdminApi {

    private final BusinessService businessService;

    @PatchMapping
    public void updateBusinessStatus(@RequestBody List<Business> businessList, HttpServletRequest request) {
        Long customerId = (long) request.getSession(true).getAttribute("stakeholderId");
        businessService.updateBusinessStatuses(businessList);
    }
}
