package edu.gjoko.schedlr.controllers.rest;

import edu.gjoko.schedlr.entity.Business;
import edu.gjoko.schedlr.entity.Stakeholder;
import edu.gjoko.schedlr.services.StakeholderService;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("api/customer")
@AllArgsConstructor
public class CustomerApi {

    private final StakeholderService stakeholderService;

    @GetMapping(path = "/me")
    public Stakeholder getCustomerInfo(HttpServletRequest request) {
        Long customerId = (long) request.getSession(true).getAttribute("stakeholderId");
        return stakeholderService.findById(customerId);
    }

    @PatchMapping
    public void updateCustomer(@RequestBody Stakeholder stakeholder, HttpServletRequest request) {
        Long customerId = (long) request.getSession(true).getAttribute("stakeholderId");
        stakeholderService.saveOrUpdateStakeholder(stakeholder, customerId);
    }
}
