package edu.gjoko.schedlr.controllers.rest;

import edu.gjoko.schedlr.entity.Service;
import edu.gjoko.schedlr.services.ServicesService;
import lombok.AllArgsConstructor;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Objects;

@RestController
@RequestMapping("api/service")
@AllArgsConstructor
public class ServiceApi {


    private ServicesService service;
    @PostMapping(path="/delete")
    public void saveBusiness(@RequestBody List<Service> serviceList) {
        if(!CollectionUtils.isEmpty(serviceList)) {
            List<Long> serviceIds = serviceList.stream()
                    .map(Service::getId)
                    .filter(Objects::nonNull)
                    .toList();
            service.deleteByIds(serviceIds);
        }
    }

    @PatchMapping
    public void updateServices (@RequestBody List<Service> serviceList, HttpServletRequest request) {
        Long ownerId = (long) request.getSession(true).getAttribute("stakeholderId");
        service.saveOrUpdateServices(serviceList, ownerId);
    }
}
