package edu.gjoko.schedlr.controllers;

import edu.gjoko.schedlr.entity.Stakeholder;
import edu.gjoko.schedlr.services.StakeholderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;

@Controller
public class RegisterController {

    private final StakeholderService stakeholderService;

    public RegisterController(StakeholderService stakeholderService) {
        this.stakeholderService = stakeholderService;
    }

    @GetMapping("/register_customer")
    public String getCustomerRegisterPage(Model model) {
        model.addAttribute("stakeholder", new Stakeholder());
        return "register_customer";
    }

    @PostMapping(value = "/register_customer")
    public String registerCustomer(@ModelAttribute Stakeholder customer, Model model) {
        Stakeholder user = stakeholderService.saveStakeholder(customer);
        model.addAttribute("user", user);
        return "homepage";
    }

    @GetMapping("/register_business")
    public String getBusinessRegisterPage(Model model) {
        return "register_business";
    }

    @PostMapping("/register_business")
    public String registerBusiness(Model model) {
        return "register_business";
    }
}
