package edu.gjoko.schedlr.config;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.filter.GenericFilterBean;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AppFilter extends GenericFilterBean {
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest) servletRequest;
        HttpSession session = httpServletRequest.getSession(false);

        if(session != null) {
            Map<String, String> roleTargetUrlMap = new HashMap<>();
            roleTargetUrlMap.put("ADMIN", "/date");
            roleTargetUrlMap.put("CUSTOMER", "/number");
            roleTargetUrlMap.put("BUSINESS_OWNER", "");
            SecurityContextImpl sci = (SecurityContextImpl) session.getAttribute("SPRING_SECURITY_CONTEXT");
            if(sci != null) {
                UserDetails userDetails = (UserDetails) sci.getAuthentication().getPrincipal();
                final Collection<? extends GrantedAuthority> authorities = userDetails.getAuthorities();
                for (final GrantedAuthority grantedAuthority : authorities) {
                    String authorityName = grantedAuthority.getAuthority();
                    if("DATE".equalsIgnoreCase(authorityName)) {
                        servletRequest.getRequestDispatcher("date").forward(servletRequest, servletResponse);
                        return;
                    } else if("GUESS_NUMBER".equalsIgnoreCase(authorityName)) {
                        try {
                            servletRequest.getRequestDispatcher("number").forward(servletRequest, servletResponse);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                        return;
                    }
                }
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}
