package edu.gjoko.schedlr.services;

import edu.gjoko.schedlr.entity.Business;
import edu.gjoko.schedlr.entity.BusinessStatus;
import edu.gjoko.schedlr.entity.ServiceType;
import edu.gjoko.schedlr.entity.StakeholderType;
import edu.gjoko.schedlr.repositories.BusinessRepository;
import edu.gjoko.schedlr.repositories.ServiceTypeRepository;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

import static edu.gjoko.schedlr.entity.BusinessStatus.ACTIVE;
import static edu.gjoko.schedlr.entity.BusinessStatus.NEW;

@Service
@AllArgsConstructor
public class BusinessService {

    private final BusinessRepository businessRepository;
    private final ServiceTypeRepository serviceTypeRepository;

    public void saveBusiness(Business business) {
        saveNewServiceTypes(business);
        business.getOwner().setStakeholderType(StakeholderType.BUSINESS_OWNER);
        business.setBusinessStatus(NEW);
        businessRepository.save(business);
    }

    public void saveNewServiceTypes(Business business) {
        business.getServices()
            .stream()
            .forEach(service -> {
                if(service.getServiceType().getId() == null) {
                    ServiceType serviceType = service.getServiceType();
                    serviceType.setBusinessType(business.getBusinessType());
                    service.setServiceType(serviceTypeRepository.save(serviceType));
                }
            });
    }

    public List<Business> getNewBusiness() {
        return businessRepository.findBusinessesByBusinessStatus(NEW);
    }

    public void activateBusinesses(List<Business> businessList) {
        businessList
                .stream()
                .forEach(business -> {
                    business.setBusinessStatus(ACTIVE);
                    businessRepository.save(business);
                });
    }

}
