$(document).ready(function() {
    var enumerations = {};
    $.ajax({
        url: "http://localhost:8080/api/nomenclatures/businessTypes"
    }).then(function (data) {
        enumerations = data;
        var $el = $("#companyType");
        //$el.empty(); // remove old options

        $.each(data, function (index, obj) {
            $el.append("<option value=" + obj.value + ">" + obj.text + "</option>");
        });
    });

    $("#companyType").change(function () {
        var selectedVal = $(this).find(':selected').val();
        var selectedObj = enumerations[selectedVal - 1];
        var $el = $("#predefined_services");
        $el.empty();
        $.each(selectedObj['serviceTypes'], function (index, obj) {
            $el.append(
                '<div class=\"form-outline mb-4\">' +
                '    <div class="row">' +
                '        <div class="col-md-8">\n' +
                '            <input class="form-check-input" type="checkbox" value=\"' + obj.id + '\" id=\"' + obj.id + '\">\n' +
                '            <label class="form-check-label" for=\"' + obj.id + '\">\n' +
                obj.name +
                '            </label>\n' +
                '        </div>' +
                '        <div class=\"form-outline col-md-2 d-grid\">' +
                '            <input type=\"text\" id=\"' + obj.id + obj.name.replace(/\s/g, "") + '\" class=\"form-control\" />' +
                '        </div>' +
                '    </div>' +
                '</div>');
        });
        $("#input_service").prop('disabled', false);
        $("#add_service").prop('disabled', false);
    });

    $("#add_service").click(function () {
        var input_service = $("#input_service").val();
        // clear the input
        $("#input_service").val('');

        /*$("#predefined_services").append(
            '<div class="form-check">\n' +
            '    <input class="form-check-input" type="checkbox" checked value=\"' + -1 + '\" id=\"'+ -1 +'\">\n' +
            '        <label class="form-check-label" for=\"' + -1 + '\">\n' +
            input_service +
            '         </label>\n' +
            '    </div>'
        );*/

        $("#predefined_services").append(
            '<div class="form-outline mb-4">' +
            '    <div class="row">' +
            '        <div class="col-md-8">\n' +
            '            <input class="form-check-input" type="checkbox" checked value="' + -1 + '" id="' + -1 + '">\n' +
            '            <label class="form-check-label" for="' + -1 + '">\n' +
            input_service +
            '            </label>\n' +
            '        </div>' +
            '        <div class="form-outline col-md-2 d-grid">' +
            '            <input type="text" id="' + -1 + input_service.replace(/\s/g, "") + '" class="form-control" />' +
            '        </div>' +
            '    </div>' +
            '</div>');
        event.preventDefault();
    });

    $('#signup_business_button').click(function () {
        let businessObj = {};
        let ownerObj = {};

        ownerObj['firstName'] = $('#firstName').val();
        ownerObj['lastName'] = $('#lastName').val();
        ownerObj['email'] = $('#email').val();
        ownerObj['username'] = $('#username').val();
        ownerObj['password'] = $('#password').val();
        businessObj['owner'] = ownerObj;

        businessObj['companyName'] = $('#companyName').val();

        businessObj['businessType'] = {'value': $('#companyType').val()};

        servicesObj = [];

        $.each($('#predefined_services input:checked').siblings(), function(index, label) {

            let service = {};
            var id = $(label).prop('for');
            var text = $(label).text();
            var time = $($($(label).parent()).siblings()[0]).children()[0].value;

            var serviceType = {}
            if(parseInt(id) != -1) {
                serviceType['id'] = id;
            }
            serviceType['name'] = text.trim();
            service['serviceType'] = serviceType;
            service['duration'] = time;
            servicesObj.push(service);
        });
        businessObj['services'] = servicesObj;
        console.log(JSON.stringify(businessObj));
        $.ajax({
            url: "http://localhost:8080/api/business",
            type:"POST",
            data: JSON.stringify(businessObj),
            contentType:"application/json; charset=utf-8",
            dataType: 'text',
            success: function(succ){
                alert( "Well done! You have finished the registration process. " +
                    "Please check periodically to see if the company has been approved." );
                window.location.href = "/homepage";
            },
            error: function(err) {
                alert(err);
            }
        });
        event.preventDefault();
    });
});