package edu.gjoko.schedlr.repositories;

import edu.gjoko.schedlr.entity.Service;
import edu.gjoko.schedlr.entity.ServiceType;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface ServiceTypeRepository extends JpaRepository<ServiceType, Long> {

    List<ServiceType> findAllByBusinessType_Id(Long businessTypeId);

    @Query(value = "select b.businessType.serviceTypes from Business as b " +
            " where b.owner.id = :ownerId")
    List<ServiceType> findAppropriateBusinessTypesForBusinessByOwnerId(Long ownerId);
}
