$(document).ready(function() {
    var businessTypes = {};
    var businesses = {};
    var date = new Date();
    var selectedServices = {};
    var events = [];
    var d = date.getDate();
    var m = date.getMonth();
    var y = date.getFullYear();

    /*  className colors

    className: default(transparent), important(red), chill(pink), success(green), info(blue)

    */

    $.ajax({
        type: 'GET',
        url: "http://localhost:8080/api/user/me",
        success: function(data, textStatus, request) {
            if (data) {
                $('#create').parent().removeClass('hidden-button');
                $('#profile').parent().removeClass('hidden-button');
                $('#logout').parent().removeClass('hidden-button');
                $('#login').parent().addClass('hidden-button');
            } else {
                $('#create').parent().addClass('hidden-button');
                $('#profile').parent().addClass('hidden-button');
                $('#logout').parent().addClass('hidden-button');
                $('#login').parent().removeClass('hidden-button');
            }
        },
        error: function (request, textStatus, errorThrown) {
            console.log(errorThrown);
        }
    });
    /* initialize the external events
    -----------------------------------------------------------------*/

    $('#external-events div.external-event').each(function() {

        // create an Event Object (http://arshaw.com/fullcalendar/docs/event_data/Event_Object/)
        // it doesn't need to have a start or end
        var eventObject = {
            title: $.trim($(this).text()) // use the element's text as the event title
        };

        // store the Event Object in the DOM element so we can get to it later
        $(this).data('eventObject', eventObject);

        // make the event draggable using jQuery UI
        $(this).draggable({
            zIndex: 999,
            revert: true,      // will cause the event to go back to its
            revertDuration: 0  //  original position after the drag
        });

    });

    $.ajax({
        url: "http://localhost:8080/api/nomenclature/businessTypes"
    }).then(function (data) {
        businessTypes = data;
        var $el = $("#companyType");
        emptyDropdown($el);

        $.each(data, function (index, obj) {
            $el.append("<option value=" + obj.value + ">" + obj.text + "</option>");
        });
    });

    $("#companyType").change(function () {
        resetRatingCard();
        var selectedVal = $(this).find(':selected').val();
        var selectedObj = businessTypes[selectedVal - 1];
        $.ajax({
            url: "http://localhost:8080/api/business/" + selectedObj.value
        }).then(function (data) {
            businesses = data;
            var $el = $("#company");
            var $servicesEl = $("#service");
            emptyDropdown($el);
            emptyDropdown($servicesEl);

            $.each(data, function (index, obj) {
                $el.append("<option value=" + obj.id + ">" + obj.companyName + "</option>");
            });

            if (data && data.length === 1) {
                selectedServices = data[0]["services"];
                resetAndAppendServices(selectedServices);
            }
        });
    });

    $("#company").change(function () {
        resetRatingCard();
        var selectedVal = $(this).find(':selected').val();
        $.ajax({
            url: "http://localhost:8080/api/appointment/business/" + selectedVal
        }).then(function (data) {
            // get already stored service from in-memory
            selectedServices = businesses.find(item => item.id == selectedVal)['services'];
            console.log(selectedServices);
            resetAndAppendServices(selectedServices);
        });
        $('#calendar').fullCalendar('refetchEvents');
    });

    $("#service").change(function () {
        var selectedVal = $("#service").find(':selected').val();
        var service = selectedServices.find(item => item.id == selectedVal);
        setRatingCard(service['serviceType']['name'], service['rating'], service['reviewsCount'], selectedVal);
    });

    $("#startdatetime").change(function() {
        var date = new Date(document.getElementById("startdatetime").valueAsDate);
        var selectedVal = $("#service").find(':selected').val();
        var minutes = selectedServices.find(item => item.id == selectedVal)['duration'];
        date.setMinutes(date.getMinutes() + minutes);
        document.getElementById("enddatetime").value = date.toISOString().slice(0, 16);
    });

    /* initialize the calendar
    -----------------------------------------------------------------*/
    loadCalendar();

    resetRatingCard();

    $("#createAppointment").click(function() {
        var appointment = {};
        var business  = {};
        business['id'] = parseInt($("#company").val());
        appointment['service'] = {'id': parseInt($("#service").val()), 'business':business};
        appointment['startTime'] = $("#startdatetime").val();

        $.ajax({
            url: "http://localhost:8080/api/appointment",
            type:"POST",
            data: JSON.stringify(appointment),
            contentType:"application/json; charset=utf-8",
            dataType: 'text',
            success: function(succ){
                alert("Successful appointment!");
                var companyId = parseInt($("#company").find(':selected').val());
                getAppointmentsByBusiness(companyId, events);
                destroyCalendar();
                loadCalendar(events);
            },
            error: function(error) {
                alert(error.responseText);
            }
        });
    });

});

document.getElementById("login").addEventListener("click", function(event){
   window.location = "/login";
});

function resetAndAppendServices(services) {
    var $el = $("#service");
    emptyDropdown($el);

    $.each(services, function (index, obj) {
        if (obj.serviceStatus === 'ACTIVE') {
            $el.append("<option value=" + obj.id + ">" + obj.serviceType.name + "</option>");
        }
    });
}

function emptyDropdown(element) {
    var defaultOption = element.children().get(0);
    element.children().remove();
    element.append(defaultOption);
}

/*loadCalendar([{'title': 'Gjoko', 'start': '2023-09-01 01:00:00', 'end': '2023-09-01 01:30:00', 'allDay':false, 'color': 'blue'}])*/

function getAppointmentsByBusiness(businessId, events) {
    $.ajax({
        url: "http://localhost:8080/api/appointment/business/" + businessId,
        type:"GET",
        contentType:"application/json; charset=utf-8",
        dataType: 'text',
        success: function(data){
            // reset events
            events = [];
            console.log(data);
           $.each(JSON.parse(data), function (index, object) {
               var event = {}
               event['title'] = object['title'];
               event['start'] = object['startTime'].replace('T', ' ');
               event['end'] = object['endTime'].replace('T', ' ');
               event['allDay'] = false;
               event['color'] = 'blue';
               events.push(event);
           });

        },
        error: function(error) {
            console.log(error.responseText);
        }
    });
}

function loadCalendar(events) {
    $('#calendar').fullCalendar({
        header: {
            left: 'title',
            center: 'agendaWeek',
            right: 'prev,next today'
        },
        editable: false,
        edit: function (start, end, allDay) {
            console.log(start);
            console.log(end);
        },
        firstDay: 1, //  1(Monday) this can be changed to 0(Sunday) for the USA system
        selectable: false,
        defaultView: 'agendaWeek',

        axisFormat: 'h:mm',
        columnFormat: {
            month: 'ddd',    // Mon
            week: 'ddd d', // Mon 7
            day: 'dddd M/d',  // Monday 9/7
            agendaDay: 'dddd d'
        },
        titleFormat: {
            month: 'MMMM yyyy', // September 2009
            week: "MMMM yyyy", // September 2009
            day: 'MMMM yyyy'                  // Tuesday, Sep 8, 2009
        },
        allDaySlot: false,
        selectHelper: true,
        select: function(start, end, allDay) {
            var title = prompt('Event Title:');
            if (title) {
                calendar.fullCalendar('renderEvent',
                    {
                        title: title,
                        start: start,
                        end: end,
                        allDay: allDay
                    },
                    true // make the event "stick"
                );
            }
            calendar.fullCalendar('unselect');
        },
        droppable: false, // this allows things to be dropped onto the calendar !!!
        drop: function(date, allDay) { // this function is called when something is dropped

            // retrieve the dropped element's stored Event Object
            var originalEventObject = $(this).data('eventObject');

            // we need to copy it, so that multiple events don't have a reference to the same object
            var copiedEventObject = $.extend({}, originalEventObject);

            // assign it the date that was reported
            copiedEventObject.start = date;
            copiedEventObject.allDay = allDay;

            // render the event on the calendar
            // the last `true` argument determines if the event "sticks" (http://arshaw.com/fullcalendar/docs/event_rendering/renderEvent/)
            $('#calendar').fullCalendar('renderEvent', copiedEventObject, true);

            // is the "remove after drop" checkbox checked?
            if ($('#drop-remove').is(':checked')) {
                // if so, remove the element from the "Draggable Events" list
                $(this).remove();
            }
            console.log('dropped');

        },
        events: function (start, end, callback) {
            var selectedVal = $("#company").find(':selected').val();
            if(!isNaN(parseInt(selectedVal))) {
                $.ajax({
                    url: "http://localhost:8080/api/appointment/business/" + selectedVal,
                    type:"GET",
                    contentType:"application/json; charset=utf-8",
                    dataType: 'text',
                    success: function(data){
                        // reset events
                        var events = [];
                        $.each(JSON.parse(data), function (index, object) {
                            var event = {}
                            event['title'] = object['title'];
                            event['start'] = object['startTime'].replace('T', ' ');
                            event['end'] = object['endTime'].replace('T', ' ');
                            event['allDay'] = false;
                            event['color'] = '#3b71ca';
                            event['textColor'] = '#FFFFFF';
                            events.push(event);
                        });
                        // load events
                        callback(events);
                    },
                    error: function(error) {
                        console.log(error.responseText);
                    }
                });
            }
        },
    });
}

function goToProfile() {
    window.location = "/customer_admin";
}

function destroyCalendar() {
    $('#calendar').fullCalendar('destroy');
}

function resetRatingCard() {
    $('#rating-service-name').empty();
    $('#rating-value').empty();
    $('#rating-count').empty();
    $('#reviews-li').remove();
}

function setRatingCard(name, value, count, serviceId) {
    $('#rating-service-name').text(name);
    $('#rating-value').text(value);
    $('#rating-count').text(count);
    $('#reviews-li').remove();
    getReviewsForService(serviceId);

}

function getReviewsForService(serviceId){
    $.ajax({
        url: "http://localhost:8080/api/review/" + serviceId
    }).then(function (data) {
        var $el = $("#reviewsModalBody");
        $('#reviews-ul').append($('<button type="button" id="reviews-li" class="btn btn-primary btn-block" data-bs-toggle="modal" data-bs-target="#showReviewsModal">Checkout reviews</button>'));
        $el.empty();

        $.each(data, function (index, obj) {
            var element = '<div class="card m-3" style="max-width: 300px; padding: 0;">';
            element +=  '<div class="card-header" style="' + generateHeaderStyle(obj['rating']) + '">' + generateStars(obj['rating']) + '</div>';
            element += '<ul class="list-group list-group-flush">';
            element += '<li class="list-group-item"><i><b>Business:</b></i> ' + obj['businessName'] + '</li>';
            element += '<li class="list-group-item"><i><b>Service:</b></i> ' + obj['serviceName'] + '</li>';
            element += '<li class="list-group-item"><i><b>Reviewer:</b></i> ' + obj['customerName'] + '</li>';
            element += '<li class="list-group-item"><i><b>Comment:</b></i> ' + obj['comment'] + '</li>';
            element += '<li class="list-group-item"><small class="text-body-secondary"><i>Created:</i> ' + obj['created'] + '</small></li>';
            element += '</ul>';
            element += '</div>';

            $el.append(element);
        });
    });
}

function generateStars(number) {
    return '☆'.repeat(number);
}

function generateHeaderStyle(number) {
    var style = '';
    switch (number) {
        case 5:
            style = 'background-color: RGBA(13,110,253,var(--bs-bg-opacity,1)) !important; ';
            break;
        case 4:
            style = 'background-color: RGBA(25,135,84,var(--bs-bg-opacity,1)) !important; ';
            break;
        case 3:
            style = 'background-color: RGBA(108,117,125,var(--bs-bg-opacity,1)) !important; ';
            break;
        case 2:
            style = 'background-color: RGBA(255,193,7,var(--bs-bg-opacity,1)) !important; ';
            break;
        case 1:
            style = 'background-color: RGBA(220,53,69,var(--bs-bg-opacity,1)) !important; ';
            break;
    }

    style += ' color: #fff !important;'
    return style;
}