package edu.gjoko.schedlr.controllers.rest;

import edu.gjoko.schedlr.entity.BusinessType;
import edu.gjoko.schedlr.entity.ServiceType;
import edu.gjoko.schedlr.services.NomenclaturesService;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("api/nomenclature")
@AllArgsConstructor
public class NomenclatureApi {

    private final NomenclaturesService nomenclaturesService;
    @GetMapping( "/businessTypes")
    public List<BusinessType> getBusinessTypes() {
        return nomenclaturesService.getBusinessTypes();
    }

    @GetMapping( "/serviceTypes/me")
    public List<ServiceType> getServiceTypesForBusinessType( HttpServletRequest request) {
        Long ownerId = (long) request.getSession(true).getAttribute("stakeholderId");
        return nomenclaturesService.findAppropriateBusinessTypesForBusinessByOwnerId(ownerId);
    }
}
