package edu.gjoko.schedlr.services;

import edu.gjoko.schedlr.entity.BusinessType;
import edu.gjoko.schedlr.entity.ServiceType;
import edu.gjoko.schedlr.repositories.BusinessTypeRepository;
import edu.gjoko.schedlr.repositories.ServiceTypeRepository;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
public class NomenclaturesService {

    private final BusinessTypeRepository businessTypeRepository;

    private final ServiceTypeRepository serviceTypeRepository;

    public List<BusinessType> getBusinessTypes () {
        return businessTypeRepository.findAll();
    }

    public List<ServiceType> findAppropriateBusinessTypesForBusinessByOwnerId(Long ownerId) {
        return serviceTypeRepository.findAppropriateBusinessTypesForBusinessByOwnerId(ownerId);
    }
}
