package edu.gjoko.schedlr.controllers.rest;

import edu.gjoko.schedlr.dto.ReviewDto;
import edu.gjoko.schedlr.entity.Review;
import edu.gjoko.schedlr.entity.Stakeholder;
import edu.gjoko.schedlr.mappers.ReviewDtoMapper;
import edu.gjoko.schedlr.services.ReviewService;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("api/review")
@AllArgsConstructor
public class ReviewApi {

    private final ReviewService reviewService;
    private final ReviewDtoMapper reviewDtoMapper;

    @PostMapping
    public void getBusinessTypes(@RequestBody Review review, HttpServletRequest request) {
        Long customerId = (long) request.getSession(true).getAttribute("stakeholderId");
        Stakeholder customer = new Stakeholder();
        customer.setId(customerId);
        reviewService.save(review, customerId);
    }

    @GetMapping(path = "/me")
    public List<ReviewDto> getReviews(HttpServletRequest request) {
        Long customerId = (long) request.getSession(true).getAttribute("stakeholderId");
        return reviewService.getReviewsByCustomerId(customerId).stream()
                .map(reviewDtoMapper::mapToReviewDto)
                .toList();
    }

    @GetMapping(path = "/{serviceId}")
    public List<ReviewDto> getReviewsForService(@PathVariable("serviceId") Long serviceId) {
        return reviewService.getReviewsByServiceId(serviceId).stream()
                .map(reviewDtoMapper::mapToReviewDto)
                .toList();
    }
}
