package edu.gjoko.schedlr.mappers;

import edu.gjoko.schedlr.dto.AppointmentDto;
import edu.gjoko.schedlr.entity.Appointment;
import org.modelmapper.Condition;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;
import org.modelmapper.config.Configuration;
import org.springframework.stereotype.Service;

@Service
public class AppointmentDtoMapper extends ModelMapper {

    public AppointmentDtoMapper() {
        this.getConfiguration().setFieldMatchingEnabled(true).setFieldAccessLevel(Configuration.AccessLevel.PRIVATE);
        TypeMap<Appointment, AppointmentDto> propertyMapper = this.createTypeMap(Appointment.class, AppointmentDto.class);
        Condition<String, String> hasTitle = ctx -> ctx.getSource() != null;
        propertyMapper.addMappings(
                mapper -> mapper.when(hasTitle).map(appointment -> appointment.getService().getServiceType().getName(), AppointmentDto::setTitle)
        );
    }
    public AppointmentDto appointmentToAppointmentDto(Appointment appointment) {
        return this.map(appointment, AppointmentDto.class);
    }
}
