package edu.gjoko.schedlr.mappers;

import edu.gjoko.schedlr.dto.AppointmentInfoDto;
import edu.gjoko.schedlr.entity.Appointment;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;
import org.modelmapper.config.Configuration;
import org.springframework.stereotype.Service;

@Service
public class AppointmentInfoDtoBusinessMapper extends ModelMapper {

    public AppointmentInfoDtoBusinessMapper() {
        this.getConfiguration().setFieldMatchingEnabled(true).setFieldAccessLevel(Configuration.AccessLevel.PRIVATE);
        TypeMap<Appointment, AppointmentInfoDto> propertyMapper = this.createTypeMap(Appointment.class, AppointmentInfoDto.class);
        propertyMapper.addMappings(
                mapper -> {
                    mapper.map(Appointment::getId, AppointmentInfoDto::setAppointmentId);
                    mapper.map(appointment -> appointment.getCustomer().getFullName(), AppointmentInfoDto::setFullName);
                    mapper.map(appointment -> appointment.getCustomer().getEmail(), AppointmentInfoDto::setEmail);
                    mapper.map(appointment -> appointment.getCustomer().getPhoneNumber(),AppointmentInfoDto::setPhoneNumber);
                    mapper.map(Appointment::getTimePeriod, AppointmentInfoDto::setTimePeriod);
                    mapper.map(appointment -> appointment.getService().getServiceType().getName(), AppointmentInfoDto::setServiceName);
                    mapper.map(Appointment::getAppointmentStatus, AppointmentInfoDto::setStatus);
                }
        );
    }

    public AppointmentInfoDto appointmentToAppointmentInfoDto(Appointment appointment) {
        return this.map(appointment, AppointmentInfoDto.class);
    }
}
