package edu.gjoko.schedlr.mappers;

import edu.gjoko.schedlr.dto.AppointmentDto;
import edu.gjoko.schedlr.dto.ReviewDto;
import edu.gjoko.schedlr.entity.Appointment;
import edu.gjoko.schedlr.entity.Review;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;
import org.modelmapper.config.Configuration;
import org.springframework.stereotype.Service;

@Service
public class ReviewDtoMapper extends ModelMapper {

    public ReviewDtoMapper() {
        this.getConfiguration().setFieldMatchingEnabled(true).setFieldAccessLevel(Configuration.AccessLevel.PRIVATE);
        TypeMap<Review, ReviewDto> propertyMapper = this.createTypeMap(Review.class, ReviewDto.class);
        propertyMapper.addMappings(mapper -> {
            mapper.map(review -> review.getAppointment().getService().getBusiness().getCompanyName(), ReviewDto::setBusinessName);
            mapper.map(review -> review.getAppointment().getCustomer().getFullName(), ReviewDto::setCustomerName);
            mapper.map(review -> review.getAppointment().getService().getServiceType().getName(), ReviewDto::setServiceName);
            mapper.map(Review::getComment, ReviewDto::setComment);
            mapper.map(Review::getRating, ReviewDto::setRating);
            mapper.map(Review::getCreated, ReviewDto::setCreated);
        }
        );
    }

    public ReviewDto mapToReviewDto(Review review) {
        return this.map(review, ReviewDto.class);
    }
}
