package edu.gjoko.schedlr.services;

import edu.gjoko.schedlr.entity.Stakeholder;
import edu.gjoko.schedlr.entity.StakeholderType;
import edu.gjoko.schedlr.repositories.StakeholderRepository;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

import java.util.Optional;

@Service
public class StakeholderService {

    private StakeholderRepository stakeholderRepository;
    private BCryptPasswordEncoder bCryptPasswordEncoder;

    public StakeholderService(StakeholderRepository stakeholderRepository,
                              BCryptPasswordEncoder bCryptPasswordEncoder) {
        this.stakeholderRepository = stakeholderRepository;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
    }

    public Stakeholder saveStakeholder(Stakeholder stakeholder) {
        stakeholder.setPassword(bCryptPasswordEncoder.encode(stakeholder.getPassword()));
        stakeholder.setStakeholderType(StakeholderType.CUSTOMER);
        return stakeholderRepository.save(stakeholder);
    }

    public Stakeholder findById(Long id) {
        return stakeholderRepository.findById(id).get();
    }

    public void saveOrUpdateStakeholder(Stakeholder stakeholder) {
        if (stakeholder.getId() != null) {
            var found = stakeholderRepository.findById(stakeholder.getId()).get();
            found.setFirstName(stakeholder.getFirstName());
            found.setLastName(stakeholder.getLastName());
            found.setPhoneNumber(stakeholder.getPhoneNumber());
            found.setEmail(stakeholder.getEmail());
            found.setUsername(stakeholder.getUsername());
            stakeholderRepository.save(found);
        }
    }
}
