$(document).ready(function() {
    var business = {};

    getBusinessInfo(business);

    getAppointments();

    $("#add_service").click(function () {
        var input_service = $("#input_service").val();
        // clear the input
        $("#input_service").val('');

        $("#predefined_services_admin_panel").append(
            '<div class="form-outline mb-4">' +
            '    <div class="row">' +
            '        <div class="col-md-6">\n' +
            '            <input class="form-check-input" type="checkbox" checked value="' + -1 + '" id="' + -1 + '">\n' +
            '            <label class="form-check-label" for="' + -1 + '">\n' +
            input_service +
            '            </label>\n' +
            '        </div>' +
            '        <div class="form-outline col-md-2 d-grid">' +
            '            <input type="text" id="' + -1 + input_service.replace(/\s/g, "") + "duration" + '" class="form-control" placeholder="time" />' +
            '        </div>' +
            '        <div class="form-outline col-md-2 d-grid">' +
            '            <input type="text" id="' + -1 + input_service.replace(/\s/g, "") + "price"+ '" class="form-control" placeholder="price" />' +
            '        </div>' +
            '    </div>' +
            '</div>');
        event.preventDefault();
    });

    $("#update_services_button").click(function () {
        businesses = [];
        console.log("Gjoko");
        servicesObj = [];
        $.each($('#predefined_services_admin_panel input:checked').siblings(), function (index, label) {

            let service = {};
            var id = $(label).prop('for');
            var text = $(label).text();
            var time = $($($(label).parent()).siblings()[0]).children()[0].value;
            var price = $($($(label).parent()).siblings()[1]).children()[0].value;

            var serviceType = {}
            if (parseInt(id) != -1) {
                service['id'] = parseInt(id);
                serviceType['id'] = business['services'].find(obj => obj.id === parseInt(id))['serviceType']['id'];
            } else {

            }
            serviceType['name'] = text.trim();
            service['serviceType'] = serviceType;
            service['duration'] = parseInt(time);
            service['price'] = parseInt(price);
            servicesObj.push(service);
        });
        business['services'] = servicesObj;

        businesses.push(business);
        console.log(JSON.stringify(businesses));

        $.ajax({
            url: "http://localhost:8080/api/business",
            type:"PATCH",
            data: JSON.stringify(businesses),
            contentType:"application/json; charset=utf-8",
            dataType: 'text',
            success: function(succ){
                alert( "Updates applied successfully" );
            },
            error: function(err) {
                alert(err);
            }
        });
        event.preventDefault();
    });

    $("#update_owner_button").click(function() {
        businesses = [];
        business['owner']['firstName'] = $('#firstName').val();
        business['owner']['lastName'] = $('#lastName').val();
        business['owner']['email'] = $('#email').val();
        business['owner']['phoneNumber'] = $('#phoneNumber').val();
        business['owner']['username'] = $('#username').val();

        businesses.push(business);
        console.log(JSON.stringify(businesses));

        $.ajax({
            url: "http://localhost:8080/api/business",
            type:"PATCH",
            data: JSON.stringify(businesses),
            contentType:"application/json; charset=utf-8",
            dataType: 'text',
            success: function(succ){
                alert( "Updates applied successfully" );
            },
            error: function(err) {
                alert(err);
            }
        });
    });
    event.preventDefault();
});

function cancelAppointment(appointmentId) {
    if (confirm("Are you sure you want to cancel the appointment?")) {
        $.ajax({
            url: "http://localhost:8080/api/appointment/" + appointmentId,
            type:"DELETE"
        }).success(function (data) {
            alert("Appointment successfully canceled.")
            getAppointments();
        }).error(function (error) {
            alert("Something went wrong.");
        });
    }
}

function getAppointments() {
    $.ajax({
        url: "http://localhost:8080/api/appointment/future/me"
    }).then(function (data) {
        console.log(data);
        var $el = $("#bookings-table-body");
        $el.empty();
        $.each(data, function (index, obj) {
            var element =
                '<tr>' +
                '   <th scope="row">' + (parseInt(index) + 1) + '</th>' +
                '   <td>' + obj['fullName'] + '</td>' +
                '   <td>' + obj['email'] + '</td>' +
                '   <td>' + obj['phoneNumber'] + '</td>' +
                '   <td>' + obj['timePeriod'] + '</td>' +
                '   <td>' + obj['serviceName'] + '</td>';

            switch (obj['status']) {
                case 'NEW':
                    element += '   <td><button type="button" class="btn btn-danger" onclick="cancelAppointment(' + obj['appointmentId'] + ')">Cancel appointment</button></td>';
                    break;
                case 'CANCELLED_BY_CUSTOMER':
                    element += '   <td><button type="button" class="btn btn-secondary" disabled>Cancelled by customer</button></td>';
                    break;
                case 'CANCELLED_BY_BUSINESS_OWNER':
                    element += '   <td><button type="button" class="btn btn-secondary" disabled>Cancelled by business owner</button></td>';
                    break;
            }
            element+='</tr>';

            $el.append(element);
        });
    });
}

function getBusinessInfo(business) {
    $.ajax({
        url: "http://localhost:8080/api/business/me"
    }).then(function (data) {
        business = data;
        var $header = $("#header");

        // header
        $header.text($header.text() + " " + business["owner"]['firstName'] + " " + business['owner']['lastName']);

        // business info
        if(business['businessStatus'] == 'NEW') {
            $('#new_business_warning').removeAttr("hidden");
        }
        $('#business_status').val(business['businessStatus']);
        $('#business_type').val(business['businessType']['text']);

        // owner info
        $('#firstName').val(business['owner']['firstName']);
        $('#lastName').val(business['owner']['lastName']);
        $('#phoneNumber').val(business['owner']['phoneNumber']);
        $('#email').val(business['owner']['email']);
        $('#username').val(business['owner']['username']);

        // services info
        var $el = $("#predefined_services_admin_panel");
        $el.empty();
        $.each(business['services'], function (index, obj) {
            $el.append(
                '<div class=\"form-outline mb-4\">' +
                '    <div class="row">' +
                '        <div class="col-md-6">\n' +
                '            <input class="form-check-input" type="checkbox" checked value=\"' + obj.id + '\" id=\"' + obj.id + '\">\n' +
                '            <label class="form-check-label" for=\"' + obj.id + '\">\n' + obj['serviceType'].name + '</label>\n' +
                '        </div>' +
                '        <div class=\"form-outline col-md-2 d-grid\">' +
                '            <input type=\"text\" id=\"' + obj.id + obj['serviceType'].name.replace(/\s/g, "") + "duration" + '\" class=\"form-control\" placeholder="time" value=\"' + obj.duration + '" />' +
                '        </div>' +
                '        <div class=\"form-outline col-md-2 d-grid\">' +
                '            <input type=\"text\" id=\"' + obj.id + obj['serviceType'].name.replace(/\s/g, "") + "price" + '\" class=\"form-control\" placeholder="price" value=\"' + obj.price + '" />' +
                '        </div>' +
                '    </div>' +
                '</div>');
        });
    });
}