package edu.gjoko.schedlr.controllers.rest;

import edu.gjoko.schedlr.dto.AppointmentDto;
import edu.gjoko.schedlr.dto.AppointmentInfoDto;
import edu.gjoko.schedlr.entity.Appointment;
import edu.gjoko.schedlr.entity.Stakeholder;
import edu.gjoko.schedlr.mappers.AppointmentDtoMapper;
import edu.gjoko.schedlr.services.AppointmentsService;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.security.sasl.AuthenticationException;
import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("api/appointment")
@AllArgsConstructor
public class AppointmentApi {

    private final AppointmentsService appointmentsService;
    private final AppointmentDtoMapper appointmentsMapper;

    @PostMapping
    public void getBusinessTypes(@RequestBody Appointment appointment, HttpServletRequest request) {
        Long customerId = (long) request.getSession(true).getAttribute("stakeholderId");
        Stakeholder customer = new Stakeholder();
        customer.setId(customerId);
        appointment.setCustomer(customer);
        appointmentsService.saveAppointment(appointment);
    }

    @GetMapping(path = "/business/{businessId}")
    public List<AppointmentDto> getAppointmentsByBusiness(@PathVariable("businessId") Long businessId) {
        return appointmentsService.getActiveAppointmentsByBusiness(businessId).stream()
                .map(appointmentsMapper::appointmentToAppointmentDto)
                .collect(Collectors.toList());
    }

    @GetMapping(path = "/future/me")
    public List<AppointmentInfoDto> getFutureAppointmentsInfoList(HttpServletRequest request) {
        Long businessOwnerId = (long) request.getSession(true).getAttribute("stakeholderId");
        return appointmentsService.getFutureAppointmentInfoList(businessOwnerId);
    }

    @GetMapping(path = "/past/me")
    public List<AppointmentInfoDto> getPastAppointmentsInfoList(HttpServletRequest request) {
        Long stakeholderId = (long) request.getSession(true).getAttribute("stakeholderId");
        return appointmentsService.getPastAppointmentInfoList(stakeholderId);
    }

    @DeleteMapping("/{appointmentId}")
    public void cancelAppointment(@PathVariable("appointmentId") Long appointmentId, HttpServletRequest request) throws AuthenticationException {
        Long stakeholderId = (long) request.getSession(true).getAttribute("stakeholderId");
        appointmentsService.deleteAppointment(appointmentId, stakeholderId);
    }
}
