package edu.gjoko.schedlr.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;
import lombok.*;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.time.LocalDateTime;

@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "appointment")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Appointment {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;

    @Column(name = "start_time")
    private LocalDateTime startTime;

    @Column(name = "end_time")
    private LocalDateTime endTime;

    @ManyToOne
    @JoinColumn(name = "stakeholder_id")
    @JsonBackReference(value = "customerAppointments")
    private Stakeholder customer;

    @ManyToOne
    @JoinColumn(name = "service_id")
    @JsonBackReference(value = "serviceAppointments")
    private Service service;

    @Column(name = "appointment_status", length = 32, columnDefinition = "varchar(32) default 'NEW'")
    @Enumerated(EnumType.STRING)
    private AppointmentStatus appointmentStatus = AppointmentStatus.NEW;

    @Column(name = "created")
    @LastModifiedDate
    private LocalDateTime created;

    @Column(name = "modified")
    @LastModifiedDate
    private LocalDateTime modified;

    public String getTimePeriod() {
        return startTime + " - " + endTime;
    }

}
