package edu.gjoko.schedlr.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.time.LocalDateTime;
import java.util.List;

@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "business_type")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class BusinessType {

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE)
    @JsonProperty("value")
    private Long id;

    @Column(name = "name")
    @JsonProperty("text")
    private String name;

    @OneToMany(mappedBy="businessType")
    @JsonManagedReference
    private List<ServiceType> serviceTypes;

    @Column(name = "created")
    @CreatedDate
    @JsonIgnore
    private LocalDateTime created;

    @Column(name = "modified")
    @LastModifiedDate
    @JsonIgnore
    private LocalDateTime modified;
}
