package edu.gjoko.schedlr.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.time.LocalDateTime;
import java.util.List;

@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "stakeholder")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class Stakeholder {

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE)
    private Long id;

    @Column(name = "stakeholder_type")
    @Enumerated(EnumType.STRING)
    private StakeholderType stakeholderType;

    @Column(name = "first_name")
    private String firstName;

    @Column(name = "last_name")
    private String lastName;

    @Column(name = "email")
    private String email;

    @Column(name = "phone_number")
    private String phoneNumber;

    @Column(name = "username")
    private String username;

    @Column(name = "password")
    private String password;

    @OneToMany(mappedBy = "customer")
    @JsonManagedReference(value = "customerAppointments")
    private List<Appointment> appointments;

    @Column(name = "created")
    @CreatedDate
    @JsonIgnore
    private LocalDateTime created;

    @Column(name = "modified")
    @LastModifiedDate
    @JsonIgnore
    private LocalDateTime modified;

    public String getFullName() {
        return firstName + " " + lastName;
    }
}
