$(document).ready(function() {

    getCustomerInfo();

    getFutureAppointments();

    getPastAppointments();

    getReviewsForCustomer();

    $("#update_customer_button").click(function() {
        var customerForSave = customer;
        customerForSave['firstName'] = $('#firstName').val();
        customerForSave['lastName'] = $('#lastName').val();
        customerForSave['email'] = $('#email').val();
        customerForSave['phoneNumber'] = $('#phoneNumber').val();
        customerForSave['username'] = $('#username').val();

        console.log(JSON.stringify(customerForSave));

        $.ajax({
            url: "http://localhost:8080/api/customer",
            type:"PATCH",
            data: JSON.stringify(customerForSave),
            contentType:"application/json; charset=utf-8",
            dataType: 'text',
            success: function(succ){
                alert( "Updates applied successfully" );
            },
            error: function(err) {
                alert(err);
            }
        });
    });


    $("#post-review-button").click(function () {
        var ratingRadios = document.getElementsByName('rating');
        var rating = 0;
        for (i = 0; i < ratingRadios.length; i++) {
            if (ratingRadios[i].checked) {
                rating = ratingRadios[i].value;
            }
        }
        var id = $('.id-class').attr('id') ;
        var message = $('#message-text').val();
        postAppointmentReview(id, rating, message);
    });

    $('#reviewModal').on('show.bs.modal', function (event) {
        // Button that triggered the modal
        const button = event.relatedTarget
        // Extract info from data-bs-* attributes
        const recipientName = button.getAttribute('data-bs-fullName');
        const recipientId = button.getAttribute('data-bs-id');

        console.log(recipientName + ' ' + recipientId);
        // If necessary, you could initiate an Ajax request here
        // and then do the updating in a callback.

        // Update the modal's content.
        const modalTitle = reviewModal.querySelector('.modal-title');
        const modalIdDiv = reviewModal.querySelector('.id-class');
        const modalBodyInput = reviewModal.querySelector('.modal-body input');

        modalTitle.textContent = `Review for ${recipientName}`;

        modalIdDiv.id = recipientId;
        modalBodyInput.value = recipientName;
    })
});

function goToHomePage() {
    window.location = "/homepage";
}

function getCustomerInfo() {
    $.ajax({
        url: "http://localhost:8080/api/customer/me"
    }).success(function (customer) {
        var $header = $("#fullName");
        $header.text(customer['firstName'] + " " + customer['lastName']);

        // customer info
        $('#firstName').val(customer['firstName']);
        $('#lastName').val(customer['lastName']);
        $('#phoneNumber').val(customer['phoneNumber']);
        $('#email').val(customer['email']);
        $('#username').val(customer['username']);
    }).error(function (error) {
        console.log(JSON.stringify(error));
    });
}

function getFutureAppointments(){
    $.ajax({
        url: "http://localhost:8080/api/appointment/future/me"
    }).then(function (data) {
        console.log(data);
        var $el = $("#appointments-table-body");
        $el.empty();
        $.each(data, function (index, obj) {
            var element =
                '<tr>' +
                '   <th scope="row">' + (parseInt(index) + 1) + '</th>' +
                '   <td>' + obj['fullName'] + '</td>' +
                '   <td>' + obj['email'] + '</td>' +
                '   <td>' + obj['phoneNumber'] + '</td>' +
                '   <td>' + obj['timePeriod'] + '</td>' +
                '   <td>' + obj['serviceName'] + '</td>';

            switch (obj['status']) {
                case 'NEW':
                    element += '   <td><button type="button" class="btn btn-danger" onclick="cancelAppointment(' + obj['appointmentId'] + ')">Cancel appointment</button></td>';
                    break;
                case 'CANCELLED_BY_CUSTOMER':
                    element += '   <td><button type="button" class="btn btn-secondary" disabled>Cancelled by customer</button></td>';
                    break;
                case 'CANCELLED_BY_BUSINESS_OWNER':
                    element += '   <td><button type="button" class="btn btn-secondary" disabled>Cancelled by business owner</button></td>';
                    break;
            }
            element+='</tr>';

            $el.append(element);
        });
    });
}

function getPastAppointments(){
    $.ajax({
        url: "http://localhost:8080/api/appointment/past/me"
    }).then(function (data) {
        var $el = $("#past-appointments-table-body");
        $el.empty();
        $.each(data, function (index, obj) {
            var element=
                '<tr>' +
                '   <th scope="row">' + (parseInt(index) + 1) + '</th>' +
                '   <td>' + obj['fullName'] + '</td>' +
                '   <td>' + obj['email'] + '</td>' +
                '   <td>' + obj['phoneNumber'] + '</td>' +
                '   <td>' + obj['timePeriod'] + '</td>' +
                '   <td>' + obj['serviceName'] + '</td>';

            switch (obj['status']) {
                case 'NEW':
                    element += '<td><button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#reviewModal" data-bs-id="' + obj['appointmentId'] + '" data-bs-fullName="' + obj['fullName'] + '">Leave a review</button></td>';
                    break;
                case 'CANCELLED_BY_CUSTOMER':
                    element += '   <td><button type="button" class="btn btn-secondary" disabled>Cancelled by you</button></td>';
                    break;
                case 'CANCELLED_BY_BUSINESS_OWNER':
                    element += '   <td><button type="button" class="btn btn-secondary" disabled>Cancelled by business owner</button></td>';
                    break;
                case 'FINISHED_AND_REVIEWED_BY_USER':
                    element += '   <td><button type="button" class="btn btn-success" disabled>Already reviewed</button></td>';
                    break;
            }
            element+='</tr>';

            $el.append(element);
        });
    });
}
function generateStars(number) {
    return '☆'.repeat(number);
}

function generateBackgroundColor(number) {
    var color = '';
    switch (number) {
        case 5:
            color = 'text-bg-primary';
            break;
        case 4:
            color = 'text-bg-success';
            break;
        case 3:
            color = 'text-bg-secondary';
            break;
        case 2:
            color = 'text-bg-warning';
            break;
        case 1:
            color = 'text-bg-danger';
            break;
    }
    return color;
}

function getReviewsForCustomer(){
    $.ajax({
        url: "http://localhost:8080/api/review/me"
    }).then(function (data) {
        console.log(data);
        var $el = $("#my-reviews");
        $el.empty();

        $.each(data, function (index, obj) {
            var element = '<div class="card m-3" style="max-width: 300px; padding: 0;">';
            element +=  '<div class="card-header ' + generateBackgroundColor(obj['rating']) + '">' + generateStars(obj['rating']) + '</div>';
            element += '<ul class="list-group list-group-flush">';
            element += '<li class="list-group-item"><i><b>Business:</b></i> ' + obj['businessName'] + '</li>';
            element += '<li class="list-group-item"><i><b>Service:</b></i> ' + obj['serviceName'] + '</li>';
            element += '<li class="list-group-item"><i><b>Reviewer:</b></i> ' + obj['customerName'] + '</li>';
            element += '<li class="list-group-item"><i><b>Comment:</b></i> ' + obj['comment'] + '</li>';
            element += '<li class="list-group-item"><small class="text-body-secondary"><i>Created:</i> ' + obj['created'] + '</small></li>';
            element += '</ul>';
            element += '</div>';

            $el.append(element);
        });
    });
}

function postAppointmentReview(appointmentId, rating, review) {
    var appointment = {};
    var ratingObj = {};
    appointment['id'] = parseInt(appointmentId);
    ratingObj['appointment'] = appointment;
    ratingObj['rating'] = parseInt(rating);
    ratingObj['comment'] = review;

    $.ajax({
        url: "http://localhost:8080/api/review",
        type:"POST",
        data: JSON.stringify(ratingObj),
        contentType:"application/json; charset=utf-8",
        dataType: 'text',
        success: function(succ){
            alert("Successful appointment!");
            $('#reviewModal').modal('toggle');
            getPastAppointments();
        },
        error: function(error) {
            alert(error.responseText);
            $('#reviewModal').modal('toggle');
        }
    });
}

function cancelAppointment(appointmentId) {
    if (confirm("Are you sure you want to cancel the appointment?")) {
        $.ajax({
            url: "http://localhost:8080/api/appointment/" + appointmentId,
            type:"DELETE"
        }).success(function (data) {
            alert("Appointment successfully canceled.")
            getAppointments();
        }).error(function (error) {
            alert("Something went wrong.");
        });
    }
}

