package edu.gjoko.schedlr.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class AppAuthenticationFailureHandler implements AuthenticationFailureHandler {

    protected Log logger = LogFactory.getLog(this.getClass());
    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
      if (exception instanceof InternalAuthenticationServiceException) {
          response.sendRedirect(request.getContextPath() + "/login?error=notApproved");
      } else if (exception instanceof BadCredentialsException) {
          response.sendRedirect(request.getContextPath() + "/login?error=badCredentials");
      }
    }
}
