$(document).ready(function() {

    var business = {};

    $.ajax({
        url: "http://localhost:8080/api/business/me"
    }).then(function (data) {
        business = data;
        console.log(business);
        var $header = $("#header");

        // header
        $header.text($header.text() + " " + business["owner"]['firstName'] + " " + business['owner']['lastName']);

        // business info
        if(business['businessStatus'] == 'NEW') {
            $('#new_business_warning').removeAttr("hidden");
        }
        $('#business_status').val(business['businessStatus']);
        $('#business_type').val(business['businessType']['text']);

        // owner info
        $('#firstName').val(business['owner']['firstName']);
        $('#lastName').val(business['owner']['lastName']);
        $('#email').val(business['owner']['email']);
        $('#username').val(business['owner']['username']);

        // services info
        var $el = $("#predefined_services_admin_panel");
        $el.empty();
        $.each(business['services'], function (index, obj) {
            $el.append(
                '<div class=\"form-outline mb-4\">' +
                '    <div class="row">' +
                '        <div class="col-md-6">\n' +
                '            <input class="form-check-input" type="checkbox" checked value=\"' + obj.id + '\" id=\"' + obj.id + '\">\n' +
                '            <label class="form-check-label" for=\"' + obj.id + '\">\n' +
                obj['serviceType'].name +
                '            </label>\n' +
                '        </div>' +
                '        <div class=\"form-outline col-md-2 d-grid\">' +
                '            <input type=\"text\" id=\"' + obj.id + obj['serviceType'].name.replace(/\s/g, "") + "duration" + '\" class=\"form-control\" placeholder="time" value=\"' + obj.duration + '" />' +
                '        </div>' +
                '        <div class=\"form-outline col-md-2 d-grid\">' +
                '            <input type=\"text\" id=\"' + obj.id + obj['serviceType'].name.replace(/\s/g, "") + "price" + '\" class=\"form-control\" placeholder="price" value=\"' + obj.price + '" />' +
                '        </div>' +
                '    </div>' +
                '</div>');
        });
    });

    $("#add_service").click(function () {
        var input_service = $("#input_service").val();
        // clear the input
        $("#input_service").val('');

        $("#predefined_services_admin_panel").append(
            '<div class="form-outline mb-4">' +
            '    <div class="row">' +
            '        <div class="col-md-6">\n' +
            '            <input class="form-check-input" type="checkbox" checked value="' + -1 + '" id="' + -1 + '">\n' +
            '            <label class="form-check-label" for="' + -1 + '">\n' +
            input_service +
            '            </label>\n' +
            '        </div>' +
            '        <div class="form-outline col-md-2 d-grid">' +
            '            <input type="text" id="' + -1 + input_service.replace(/\s/g, "") + "duration" + '" class="form-control" placeholder="time" />' +
            '        </div>' +
            '        <div class="form-outline col-md-2 d-grid">' +
            '            <input type="text" id="' + -1 + input_service.replace(/\s/g, "") + "price"+ '" class="form-control" placeholder="price" />' +
            '        </div>' +
            '    </div>' +
            '</div>');
        event.preventDefault();
    });
});