package edu.gjoko.schedlr.config;

import edu.gjoko.schedlr.services.PostgresUserDetailsService;
import lombok.RequiredArgsConstructor;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.filter.GenericFilterBean;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@RequiredArgsConstructor
public class AppFilter extends GenericFilterBean {

    private final PostgresUserDetailsService userDetailsService;
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest) servletRequest;
        HttpSession session = httpServletRequest.getSession(false);
        HttpServletResponse response = (HttpServletResponse) servletResponse;

        if(httpServletRequest.getRequestURI().endsWith(".js")
                || httpServletRequest.getRequestURI().endsWith(".css")) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }

        if(httpServletRequest.getRequestURI().startsWith("/api")) {
            session = ((HttpServletRequest) servletRequest).getSession(true);
            SecurityContextImpl sci = (SecurityContextImpl) session.getAttribute("SPRING_SECURITY_CONTEXT");

            if(sci != null && session.getAttribute("stakeholderId") == null) {
                UserDetails userDetails = (UserDetails) sci.getAuthentication().getPrincipal();
                Long stakeholderId = userDetailsService.loadStakeholderId(userDetails.getUsername());
                session.setAttribute("stakeholderId", stakeholderId);
            }
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }

        if(session != null) {
            SecurityContextImpl sci = (SecurityContextImpl) session.getAttribute("SPRING_SECURITY_CONTEXT");
            if(sci != null) {
                UserDetails userDetails = (UserDetails) sci.getAuthentication().getPrincipal();
                Long stakeholderId = userDetailsService.loadStakeholderId(userDetails.getUsername());
                session.setAttribute("stakeholderId", stakeholderId);

                final Collection<? extends GrantedAuthority> authorities = userDetails.getAuthorities();
                for (final GrantedAuthority grantedAuthority : authorities) {
                    String authorityName = grantedAuthority.getAuthority();
                    String page = "";
                    switch (authorityName) {
                        case "ADMIN":
                            page = "/admin";
                            break;
                        case "CUSTOMER":
                            page = "/homepage";
                            break;
                        case "BUSINESS_OWNER":
                            page = "/business_admin";
                            break;
                        default:
                            break;
                    }
                    if(page != null && !page.trim().isEmpty()) {
                        servletRequest.getRequestDispatcher(page).forward(servletRequest, servletResponse);
                        return;
                    }
                }
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}
