package edu.gjoko.schedlr.controllers;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

import javax.servlet.http.HttpServletRequest;
import java.security.Principal;

@Controller
public class AdminController {

    @GetMapping(path = "/admin")
    public String getAdminPageTemplate(Model model, HttpServletRequest request) {
        return "admin";
    }

    @GetMapping(path = "/business_admin")
    public String getBusinessAdminPageTemplate(Model model, HttpServletRequest request) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String currentPrincipalName = authentication.getName();

        return "business_admin";
    }


}