package edu.gjoko.schedlr.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.time.LocalDateTime;
import java.util.List;

@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "business")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class Business {

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE)
    private Long id;

    @Column(name = "company_name")
    private String companyName;

    @OneToOne
    @JoinColumn(name = "business_type_id", referencedColumnName = "id")
    @JsonProperty("businessType")
    private BusinessType businessType;

    @ManyToOne(cascade = CascadeType.PERSIST)
    @JoinColumn(name = "owner_id", referencedColumnName = "id", nullable = false)
    @JsonProperty("owner")
    private Stakeholder owner;

    @OneToMany(mappedBy = "business", cascade = CascadeType.PERSIST)
    @JsonManagedReference
    private List<Service> services;

    @Column(name = "business_status")
    @Enumerated(EnumType.STRING)
    private BusinessStatus businessStatus;

    @Column(name = "created")
    @CreatedDate
    @JsonIgnore
    private LocalDateTime created;

    @Column(name = "modified")
    @LastModifiedDate
    @JsonIgnore
    private LocalDateTime modified;


}
