package edu.gjoko.schedlr.services;

import edu.gjoko.schedlr.entity.Business;
import edu.gjoko.schedlr.entity.BusinessStatus;
import edu.gjoko.schedlr.entity.Stakeholder;
import edu.gjoko.schedlr.entity.StakeholderType;
import edu.gjoko.schedlr.repositories.BusinessRepository;
import edu.gjoko.schedlr.repositories.StakeholderRepository;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.Set;

@Service
@RequiredArgsConstructor
public class PostgresUserDetailsService implements UserDetailsService {

    private final StakeholderRepository stakeholderRepository;
    private final BCryptPasswordEncoder bCryptPasswordEncoder;

    private final BusinessRepository businessRepository;

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Stakeholder user = stakeholderRepository.findStakeholderByUsername(username);
        if(user == null) {
            throw new UsernameNotFoundException("Non existing user");
        }

        if(user.getStakeholderType() == StakeholderType.BUSINESS_OWNER) {
            Business business = businessRepository.findBusinessByOwner(user);
            if (business.getBusinessStatus() != BusinessStatus.ACTIVE) {
                throw new SecurityException("User not approved by admin");
            }
        }
        Set<GrantedAuthority> grantedAuthorities = new HashSet<>();
        grantedAuthorities.add(new SimpleGrantedAuthority(user.getStakeholderType().name()));

        return new User(user.getUsername(), user.getPassword(), grantedAuthorities);
    }

    public Long loadStakeholderId(String username) {
        return stakeholderRepository.findStakeholderByUsername(username).getId();
    }
}
