package edu.gjoko.schedlr.config;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AppFilter extends GenericFilterBean {
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest) servletRequest;
        HttpSession session = httpServletRequest.getSession(false);

        if(httpServletRequest.getRequestURI().endsWith(".js")
                || httpServletRequest.getRequestURI().endsWith(".css")
                || httpServletRequest.getRequestURI().startsWith("/api")) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if(session != null) {
            Map<String, String> roleTargetUrlMap = new HashMap<>();
            roleTargetUrlMap.put("ADMIN", "/admin");
            roleTargetUrlMap.put("CUSTOMER", "/homepage");
            roleTargetUrlMap.put("BUSINESS_OWNER", "/business_homepage");
            SecurityContextImpl sci = (SecurityContextImpl) session.getAttribute("SPRING_SECURITY_CONTEXT");
            if(sci != null) {
                UserDetails userDetails = (UserDetails) sci.getAuthentication().getPrincipal();
                final Collection<? extends GrantedAuthority> authorities = userDetails.getAuthorities();
                for (final GrantedAuthority grantedAuthority : authorities) {
                    String authorityName = grantedAuthority.getAuthority();
                    String page = "";
                    switch (authorityName) {
                        case "ADMIN":
                            page = "/admin";
                            break;
                        case "CUSTOMER":
                        case "BUSINESS_OWNER":
                            page = "/homepage";
                            break;
                        default:
                            break;
                    }
                    if(page != null && !page.trim().isEmpty()) {
                        servletRequest.getRequestDispatcher(page).forward(servletRequest, servletResponse);
                        return;
                    }
                }
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}
