package edu.gjoko.schedlr.controllers.rest;

import edu.gjoko.schedlr.entity.Business;
import edu.gjoko.schedlr.services.BusinessService;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("api/business")
@AllArgsConstructor
public class BusinessController {

    final BusinessService businessService;

    @PostMapping
    public void getBusinessTypes(@RequestBody Business business) {
        businessService.saveBusiness(business);
    }

    @GetMapping
    public List<Business> findAll() {
        return businessService.findAll();
    }

    @PatchMapping
    public void updateBusinesses(@RequestBody List<Business> businessList) {
        businessService.updateBusinesses(businessList);
    }
}
