package edu.gjoko.schedlr.controllers.rest;

import edu.gjoko.schedlr.entity.Appointment;
import edu.gjoko.schedlr.entity.Business;
import edu.gjoko.schedlr.entity.Stakeholder;
import edu.gjoko.schedlr.repositories.AppointmentRepository;
import edu.gjoko.schedlr.services.AppointmentsService;
import edu.gjoko.schedlr.services.StakeholderService;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("api/appointment")
@AllArgsConstructor
public class AppointmentController {

    private final AppointmentsService appointmentsService;

    @PostMapping
    public void getBusinessTypes(@RequestBody Appointment appointment, HttpServletRequest request) {
        Long customerId = (long) request.getSession(true).getAttribute("stakeholderId");
        Stakeholder customer = new Stakeholder();
        customer.setId(customerId);
        appointment.setCustomer(customer);
        appointmentsService.saveAppointment(appointment);
    }

    @GetMapping(path = "/business/{businessId}")
    public List<Appointment> getAppointmentsByBusiness(@PathVariable("businessId") Long businessId) {
        var business = new Business();
        business.setId(businessId);
        return appointmentsService.getAppointmentsByBusiness(business);
    }
}
