package edu.gjoko.schedlr.repositories;

import edu.gjoko.schedlr.entity.Business;
import edu.gjoko.schedlr.entity.BusinessStatus;
import edu.gjoko.schedlr.entity.BusinessType;
import edu.gjoko.schedlr.entity.Stakeholder;
import org.hibernate.Session;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface BusinessRepository extends JpaRepository<Business, Long> {

    Business findBusinessByOwner(Stakeholder owner);

    List<Business> findBusinessesByBusinessTypeAndBusinessStatus(BusinessType businessType, BusinessStatus businessStatus);
}
