package edu.gjoko.schedlr.services;

import edu.gjoko.schedlr.entity.Appointment;
import edu.gjoko.schedlr.entity.Business;
import edu.gjoko.schedlr.entity.Stakeholder;
import edu.gjoko.schedlr.exceptions.BlockingTimeException;
import edu.gjoko.schedlr.repositories.AppointmentRepository;
import edu.gjoko.schedlr.repositories.ServiceRepository;
import edu.gjoko.schedlr.repositories.ServiceTypeRepository;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
public class AppointmentsService {

    private final AppointmentRepository appointmentRepository;

    private final ServiceRepository serviceRepository;

    public void saveAppointment(Appointment appointment) {
        var service = serviceRepository.findById(appointment.getService().getId()).get();
        appointment.setEndTime(appointment.getStartTime().plusMinutes(service.getDuration()));
        List<Appointment> blockingAppointments = appointmentRepository.
                findBlockingAppointments(
                        appointment.getBusiness().getId(), appointment.getStartTime(), appointment.getEndTime());

        // check to see if there are blocking exceptions
        if (blockingAppointments != null && !blockingAppointments.isEmpty()) {
            throw new BlockingTimeException();
        }
        appointmentRepository.save(appointment);
    }

    public List<Appointment> getAppointmentsByBusiness(Business business) {
        return appointmentRepository.getAppointmentsByBusiness(business);
    }

    private List<Appointment> getAppointmentsByCustomer(Stakeholder stakeholder) {
        return appointmentRepository.getAppointmentsByCustomer(stakeholder);
    }
}
